/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.runtime.CRowWrappingCollector;
import org.apache.flink.table.runtime.join.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u000b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011AFQ1tKR;x.\u00138qkR\u001cFO]3b[>\u0003XM]1u_J<\u0016\u000e\u001e5Ti\u0006$XMU3uK:$\u0018n\u001c8\u0011\u0007UA\"$D\u0001\u0017\u0015\t9b!A\u0004d_\u0012,w-\u001a8\n\u0005e1\"\u0001C\"p[BLG.\u001a:\u0011\u000bm\u0011C\u0005\n\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u0010!\u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0005C\u0001\u0004CBL\u0017BA\u0012\u001d\u0005A1E.\u0019;K_&tg)\u001e8di&|g\u000e\u0005\u0002&Q5\taE\u0003\u0002(\u0011\u0005)A/\u001f9fg&\u0011\u0011F\n\u0002\u0004%><\bCA\u0016/\u001b\u0005a#BA\u0017\u0007\u0003\u0011)H/\u001b7\n\u0005=b#a\u0002'pO\u001eLgn\u001a\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005AA.\u001a4u)f\u0004X\rE\u00024m\u0011j\u0011\u0001\u000e\u0006\u0003ky\t\u0001\u0002^=qK&tgm\\\u0005\u0003oQ\u0012q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\ts\u0001\u0011\t\u0011)A\u0005e\u0005I!/[4iiRK\b/\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005yq-\u001a8K_&tg)\u001e8d\u001d\u0006lW\r\u0005\u0002>\u0007:\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011u\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003=\u0003=9WM\u001c&pS:4UO\\2D_\u0012,\u0007\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002!5LgNU3uK:$\u0018n\u001c8US6,\u0007C\u0001 L\u0013\tauH\u0001\u0003M_:<\u0007\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002!5\f\u0007PU3uK:$\u0018n\u001c8US6,\u0007\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002#1,g\r\u001e+j[\u0016\fE\u000f\u001e:jEV$X\r\u0005\u0002?%&\u00111k\u0010\u0002\u0004\u0013:$\b\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002%ILw\r\u001b;US6,\u0017\t\u001e;sS\n,H/\u001a\u0005\u0006/\u0002!\t\u0001W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013eS6\fX/_?\u0002\f\u0007CA\t\u0001\u0011\u0015\td\u000b1\u00013\u0011\u0015Id\u000b1\u00013\u0011\u0015Yd\u000b1\u0001=\u0011\u00159e\u000b1\u0001=\u0011\u0015Ie\u000b1\u0001K\u0011\u0015qe\u000b1\u0001K\u0011\u0015\u0001f\u000b1\u0001R\u0011\u0015)f\u000b1\u0001R\u0011\u001d\u0019\u0007A1A\u0005\n\u0011\f!DT#Y)~cUI\u0012+`\u0013:#U\tW0T)\u0006#Vi\u0018(B\u001b\u0016+\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA\u0001\\1oO*\t!.\u0001\u0003kCZ\f\u0017B\u0001#h\u0011\u0019i\u0007\u0001)A\u0005K\u0006Yb*\u0012-U?2+e\tV0J\u001d\u0012+\u0005lX*U\u0003R+uLT!N\u000b\u0002Bqa\u001c\u0001C\u0002\u0013%A-A\bM\u000b\u001a#vl\u0015+B)\u0016{f*Q'F\u0011\u0019\t\b\u0001)A\u0005K\u0006\u0001B*\u0012$U?N#\u0016\tV#`\u001d\u0006kU\t\t\u0005\bg\u0002\u0011\r\u0011\"\u0003e\u0003A\u0011\u0016j\u0012%U?N#\u0016\tV#`\u001d\u0006kU\t\u0003\u0004v\u0001\u0001\u0006I!Z\u0001\u0012%&;\u0005\nV0T)\u0006#Vi\u0018(B\u001b\u0016\u0003\u0003bB<\u0001\u0005\u0004%I\u0001Z\u0001\u001c%\u0016;\u0015j\u0015+F%\u0016#u\fV%N\u000bJ{6\u000bV!U\u000b~s\u0015)T#\t\re\u0004\u0001\u0015!\u0003f\u0003q\u0011ViR%T)\u0016\u0013V\tR0U\u00136+%kX*U\u0003R+uLT!N\u000b\u0002Bqa\u001f\u0001C\u0002\u0013%A-A\tU\u00136+%kU0T)\u0006#Vi\u0018(B\u001b\u0016Ca! \u0001!\u0002\u0013)\u0017A\u0005+J\u001b\u0016\u00136kX*U\u0003R+uLT!N\u000b\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u0017e&<\u0007\u000e\u001e*poRLW.Z\"p[B\f'/\u0019;peV\u0011\u00111\u0001\t\u0004#\u0005\u0015\u0011bAA\u0004\u0005\t\t\"k\\<uS6,7i\\7qCJ\fGo\u001c:\t\u0011\u0005-\u0001\u0001)A\u0005\u0003\u0007\tqC]5hQR\u0014vn\u001e;j[\u0016\u001cu.\u001c9be\u0006$xN\u001d\u0011\t\u0017\u0005=\u0001\u00011AA\u0002\u0013%\u0011\u0011C\u0001\u000e]\u0016DH\u000fT3gi&sG-\u001a=\u0016\u0005\u0005M\u0001CBA\u000b\u00037\ty\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0010\u0002\u000bM$\u0018\r^3\n\t\u0005u\u0011q\u0003\u0002\u000b-\u0006dW/Z*uCR,\u0007c\u00014\u0002\"%\u0011Aj\u001a\u0005\f\u0003K\u0001\u0001\u0019!a\u0001\n\u0013\t9#A\toKb$H*\u001a4u\u0013:$W\r_0%KF$B!!\u000b\u00020A\u0019a(a\u000b\n\u0007\u00055rH\u0001\u0003V]&$\bBCA\u0019\u0003G\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005U\u0002\u0001)Q\u0005\u0003'\taB\\3yi2+g\r^%oI\u0016D\b\u0005C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0012!\u00037fMR\u001cF/\u0019;f+\t\ti\u0004E\u0004\u0002\u0016\u0005}\u0012q\u0004\u0013\n\t\u0005\u0005\u0013q\u0003\u0002\t\u001b\u0006\u00048\u000b^1uK\"Y\u0011Q\t\u0001A\u0002\u0003\u0007I\u0011BA$\u00035aWM\u001a;Ti\u0006$Xm\u0018\u0013fcR!\u0011\u0011FA%\u0011)\t\t$a\u0011\u0002\u0002\u0003\u0007\u0011Q\b\u0005\t\u0003\u001b\u0002\u0001\u0015)\u0003\u0002>\u0005QA.\u001a4u'R\fG/\u001a\u0011\t\u0017\u0005E\u0003\u00011AA\u0002\u0013%\u00111H\u0001\u000be&<\u0007\u000e^*uCR,\u0007bCA+\u0001\u0001\u0007\t\u0019!C\u0005\u0003/\naB]5hQR\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005e\u0003BCA\u0019\u0003'\n\t\u00111\u0001\u0002>!A\u0011Q\f\u0001!B\u0013\ti$A\u0006sS\u001eDGo\u0015;bi\u0016\u0004\u0003bCA1\u0001\u0001\u0007\t\u0019!C\u0005\u0003#\tqB]3hSN$XM]3e)&lWM\u001d\u0005\f\u0003K\u0002\u0001\u0019!a\u0001\n\u0013\t9'A\nsK\u001eL7\u000f^3sK\u0012$\u0016.\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005%\u0004BCA\u0019\u0003G\n\t\u00111\u0001\u0002\u0014!A\u0011Q\u000e\u0001!B\u0013\t\u0019\"\u0001\tsK\u001eL7\u000f^3sK\u0012$\u0016.\\3sA!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011BA:\u0003-\u0019'k\\<Xe\u0006\u0004\b/\u001a:\u0016\u0005\u0005U\u0004\u0003BA<\u0003sj\u0011\u0001B\u0005\u0004\u0003w\"!!F\"S_^<&/\u00199qS:<7i\u001c7mK\u000e$xN\u001d\u0005\f\u0003\u007f\u0002\u0001\u0019!a\u0001\n\u0013\t\t)A\bd%><xK]1qa\u0016\u0014x\fJ3r)\u0011\tI#a!\t\u0015\u0005E\u0012QPA\u0001\u0002\u0004\t)\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0015BA;\u00031\u0019'k\\<Xe\u0006\u0004\b/\u001a:!\u0011-\tY\t\u0001a\u0001\u0002\u0004%I!!$\u0002\u0013\r|G\u000e\\3di>\u0014XCAAH!\u0019\t\t*!(\u0002\"6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*A\u0005pa\u0016\u0014\u0018\r^8sg*\u0019\u0011%!'\u000b\u0007\u0005m\u0005\"A\u0005tiJ,\u0017-\\5oO&!\u0011qTAJ\u0005Q!\u0016.\\3ti\u0006l\u0007/\u001a3D_2dWm\u0019;peB!\u00111UAT\u001b\t\t)K\u0003\u0002(\t%!\u0011\u0011VAS\u0005\u0011\u0019%k\\<\t\u0017\u00055\u0006\u00011AA\u0002\u0013%\u0011qV\u0001\u000eG>dG.Z2u_J|F%Z9\u0015\t\u0005%\u0012\u0011\u0017\u0005\u000b\u0003c\tY+!AA\u0002\u0005=\u0005\u0002CA[\u0001\u0001\u0006K!a$\u0002\u0015\r|G\u000e\\3di>\u0014\b\u0005C\u0006\u0002:\u0002\u0001\r\u00111A\u0005\n\u0005m\u0016\u0001\u00046pS:4UO\\2uS>tW#\u0001\u000e\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011Y\u0001\u0011U>LgNR;oGRLwN\\0%KF$B!!\u000b\u0002D\"I\u0011\u0011GA_\u0003\u0003\u0005\rA\u0007\u0005\b\u0003\u000f\u0004\u0001\u0015)\u0003\u001b\u00035Qw.\u001b8Gk:\u001cG/[8oA!9\u00111\u001a\u0001\u0005B\u00055\u0017\u0001B8qK:$\"!!\u000b\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\u0006y\u0001O]8dKN\u001cX\t\\3nK:$\u0018\u0007\u0006\u0003\u0002*\u0005U\u0007\u0002CAl\u0003\u001f\u0004\r!!7\u0002\u000f\u0015dW-\\3oiB1\u00111\\Ar\u0003Ck!!!8\u000b\t\u0005}\u0017\u0011]\u0001\rgR\u0014X-Y7sK\u000e|'\u000f\u001a\u0006\u0004\u000b\u0005e\u0015\u0002BAs\u0003;\u0014Ab\u0015;sK\u0006l'+Z2pe\u0012Dq!!;\u0001\t\u0003\nY/A\bqe>\u001cWm]:FY\u0016lWM\u001c;3)\u0011\tI#!<\t\u0011\u0005]\u0017q\u001da\u0001\u00033Dq!!=\u0001\t\u0003\n\u00190A\u0006p]\u00163XM\u001c;US6,G\u0003BA\u0015\u0003kD\u0001\"a>\u0002p\u0002\u0007\u0011\u0011`\u0001\u0006i&lWM\u001d\t\t\u0003#\u000bY0a@\u0003\u0006%!\u0011Q`AJ\u00055Ie\u000e^3s]\u0006dG+[7feB\u0019aH!\u0001\n\u0007\t\rqHA\u0002B]f\u0004BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0005\u00033\u0011YA\u0003\u0002\u0006\u0011%!!q\u0002B\u0005\u000551v.\u001b3OC6,7\u000f]1dK\"9!1\u0003\u0001\u0005B\u00055\u0017!B2m_N,\u0007b\u0002B\f\u0001\u0011%!\u0011D\u0001\u0016e\u0016<\u0017n\u001d;feNk\u0017\r\u001c7fgR$\u0016.\\3s)\u0011\tICa\u0007\t\u000f\tu!Q\u0003a\u0001\u0015\u0006IA/[7fgR\fW\u000e\u001d\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u00035\u0011XmZ5ti\u0016\u0014H+[7feR!\u0011\u0011\u0006B\u0013\u0011\u001d\u0011iBa\bA\u0002)CqA!\u000b\u0001\t\u0013\u0011Y#A\rf[&$(+Z:vYR\fe\u000eZ\"mK\u0006tW\u000b]*uCR,Gc\u0001&\u0003.!9!q\u0006B\u0014\u0001\u0004Q\u0015A\u0004;j[\u0016\u0014H+[7fgR\fW\u000e\u001d\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u00031\u0019G.Z1o+B\u001cF/\u0019;f)\u0019\tICa\u000e\u0003:!9!q\u0006B\u0019\u0001\u0004Q\u0005\u0002\u0003B\u001e\u0005c\u0001\rA!\u0010\u0002\u001fILw\r\u001b;S_^\u001c8k\u001c:uK\u0012\u0004RAa\u0010\u0003D\u0011j!A!\u0011\u000b\u00055J\u0017\u0002\u0002B#\u0005\u0003\u0012A\u0001T5ti\"9!1\u0007\u0001\u0005B\t%C\u0003BA\u0015\u0005\u0017BqA!\u0014\u0003H\u0001\u0007!*\u0001\u0003uS6,\u0007b\u0002B)\u0001\u0011%!1K\u0001\u0011M&\u00148\u000f^%oI\u0016DHk\\&fKB$R!\u0015B+\u0005/BqAa\f\u0003P\u0001\u0007!\n\u0003\u0005\u0003<\t=\u0003\u0019\u0001B\u001f\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;\n\u0011%\u001b8eKb|eMR5sgR,E.Z7f]RtUm^3s)\"\fg\u000eV5nKJ$R!\u0015B0\u0005CBqAa\f\u0003Z\u0001\u0007!\n\u0003\u0005\u0003d\te\u0003\u0019\u0001B\u001f\u0003\u0011a\u0017n\u001d;\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j\u0005!B.\u0019;fgR\u0014\u0016n\u001a5u%><Hk\u001c&pS:$bAa\u001b\u0003r\tM\u0004#\u0002B \u0005[\"\u0013\u0002\u0002B8\u0005\u0003\u0012\u0001b\u00149uS>t\u0017\r\u001c\u0005\t\u0005w\u0011)\u00071\u0001\u0003>!9!Q\u000fB3\u0001\u0004Q\u0015\u0001\u00037fMR$\u0016.\\3\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003zQQ!1\u000eB>\u0005{\u0012\tI!\"\t\u0011\tm\"q\u000fa\u0001\u0005{AqAa \u0003x\u0001\u0007\u0011+A\u0002m_^DqAa!\u0003x\u0001\u0007\u0011+\u0001\u0003iS\u001eD\u0007b\u0002B;\u0005o\u0002\rA\u0013\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0003I9W\r\u001e*jO\"$(k\\<t'>\u0014H/\u001a3\u0015\t\tu\"Q\u0012\u0005\t\u0005\u001f\u00139\t1\u0001\u0002\u0004\u0005\t\"o\\<uS6,7i\\7qCJ\fGo\u001c:\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\u0006\u0001r-\u001a;OKb$H*\u001a4u\u0013:$W\r_\u000b\u0003\u0003?AqA!'\u0001\t\u0013\u0011Y*A\u0006hKRdUM\u001a;US6,Gc\u0001&\u0003\u001e\"9!q\u0014BL\u0001\u0004!\u0013a\u00027fMR\u0014vn\u001e\u0005\b\u0005G\u0003A\u0011\u0002BS\u000319W\r\u001e*jO\"$H+[7f)\rQ%q\u0015\u0005\b\u0005S\u0013\t\u000b1\u0001%\u0003!\u0011\u0018n\u001a5u%><\bb\u0002BW\u0001\u0011%!qV\u0001\u0013G\",7m\u001b(piJ+GO]1di&|g\u000e\u0006\u0003\u0002*\tE\u0006\u0002CAl\u0005W\u0003\r!!7")
public class TemporalRowtimeJoin
extends BaseTwoInputStreamOperatorWithStateRetention
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, Row> leftState;
    private MapState<Long, Row> rightState;
    private ValueState<Long> registeredTimer;
    private CRowWrappingCollector cRowWrapper;
    private TimestampedCollector<CRow> collector;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, Row> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, Row> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, Row> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, Row> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    private CRowWrappingCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    private void cRowWrapper_$eq(CRowWrappingCollector x$1) {
        this.cRowWrapper = x$1;
    }

    private TimestampedCollector<CRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<CRow> x$1) {
        this.collector = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    @Override
    public void open() {
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling FlatJoinFunction: ", " \\n\\n Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncName, this.genJoinFuncCode})));
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating FlatJoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)new Configuration());
        this.nextLeftIndex_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.NEXT_LEFT_INDEX_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.LEFT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.RIGHT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.REGISTERED_TIMER_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<CRow>)new TimestampedCollector(this.output));
        this.cRowWrapper_$eq(new CRowWrappingCollector());
        this.cRowWrapper().out_$eq((Collector<CRow>)this.collector());
        this.cRowWrapper().setChange(true);
        super.open();
    }

    public void processElement1(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        this.leftState().put((Object)this.getNextLeftIndex(), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(this.getLeftTime(((CRow)element.getValue()).row()));
        this.registerProcessingCleanUpTimer();
    }

    public void processElement2(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        long rowTime = this.getRightTime(((CRow)element.getValue()).row());
        this.rightState().put((Object)Predef$.MODULE$.long2Long(rowTime), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(rowTime);
        this.registerProcessingCleanUpTimer();
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        this.registeredTimer().clear();
        long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
        if (lastUnprocessedTime < Long.MAX_VALUE) {
            this.registerTimer(lastUnprocessedTime);
        }
        if (this.stateCleaningEnabled()) {
            if (lastUnprocessedTime >= Long.MAX_VALUE && this.rightState().isEmpty()) {
                this.cleanUpLastTimer();
            } else {
                this.registerProcessingCleanUpTimer();
            }
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    private void registerSmallestTimer(long timestamp) {
        Long currentRegisteredTimer = (Long)this.registeredTimer().value();
        if (currentRegisteredTimer == null) {
            this.registerTimer(timestamp);
        } else if (currentRegisteredTimer != null && Predef$.MODULE$.Long2long(currentRegisteredTimer) > timestamp) {
            this.timerService().deleteEventTimeTimer(Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update((Object)Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer(timestamp);
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<Row> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry leftEntry = (Map.Entry)leftIterator.next();
            Row leftRow = (Row)leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<Row> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join((Object)leftRow, (Object)rightRow.get(), (Collector)this.cRowWrapper());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<Row> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove((Object)Predef$.MODULE$.long2Long(rightTime));
        }
    }

    @Override
    public void cleanUpState(long time) {
        this.leftState().clear();
        this.rightState().clear();
    }

    private int firstIndexToKeep(long timerTimestamp, List<Row> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<Row> list) {
        ListIterator<Row> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, int low, int high, long leftTime) {
        Optional<Row> optional;
        block3: {
            Row midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<Row> rightRows = new ArrayList<Row>();
        JavaConversions$.MODULE$.iterableAsScalaIterable(this.rightState().values()).foreach((Function1)new Serializable(this, rightRows){
            public static final long serialVersionUID = 0L;
            private final ArrayList rightRows$1;

            public final boolean apply(Row row) {
                return this.rightRows$1.add(row);
            }
            {
                this.rightRows$1 = rightRows$1;
            }
        });
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = (Long)this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update((Object)Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(Row leftRow) {
        return BoxesRunTime.unboxToLong((Object)leftRow.getField(this.leftTimeAttribute));
    }

    private long getRightTime(Row rightRow) {
        return BoxesRunTime.unboxToLong((Object)rightRow.getField(this.rightTimeAttribute));
    }

    private void checkNotRetraction(StreamRecord<CRow> element) {
        if (((CRow)element.getValue()).change()) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retractions are not supported by [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TemporalRowtimeJoin.class.getSimpleName()}))).append((Object)"If this can happen it should be validated during planning!").toString());
    }

    public TemporalRowtimeJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, long minRetentionTime, long maxRetentionTime, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

