/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.triggers;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001=\u0011\u0011d\u0015;bi\u0016\u001cE.Z1oS:<7i\\;oiR\u0013\u0018nZ4fe*\u00111\u0001B\u0001\tiJLwmZ3sg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\tEI2$I\u0007\u0002%)\u00111a\u0005\u0006\u0003)U\t\u0011b^5oI><\u0018N\\4\u000b\u0005Y9\u0012aA1qS*\u0011\u0001\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!A\u0007\n\u0003\u000fQ\u0013\u0018nZ4feB\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t\u0019\u0011I\\=\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u001a\u0012aB<j]\u0012|wo]\u0005\u0003M\r\u0012Ab\u00127pE\u0006dw+\u001b8e_^D\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0011[&t'+\u001a;f]RLwN\u001c+j[\u0016\u0004\"\u0001\b\u0016\n\u0005-j\"\u0001\u0002'p]\u001eD\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0011[\u0006D(+\u001a;f]RLwN\u001c+j[\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I!K\u0001\t[\u0006D8i\\;oi\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"BaM\u001b7oA\u0011A\u0007A\u0007\u0002\u0005!)\u0001\u0006\ra\u0001S!)Q\u0006\ra\u0001S!)q\u0006\ra\u0001S!9\u0011\b\u0001b\u0001\n#Q\u0014\u0001F:uCR,7\t\\3b]&tw-\u00128bE2,G-F\u0001<!\taB(\u0003\u0002>;\t9!i\\8mK\u0006t\u0007BB \u0001A\u0003%1(A\u000bti\u0006$Xm\u00117fC:LgnZ#oC\ndW\r\u001a\u0011\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u0006I1\u000f^1uK\u0012+7oY\u000b\u0002\u0007B\u0019AI\u0013'\u000e\u0003\u0015S!AR$\u0002\u000bM$\u0018\r^3\u000b\u0005!K\u0015AB2p[6|gN\u0003\u0002\u0017\u0011%\u00111*\u0012\u0002\u0018%\u0016$WoY5oON#\u0018\r^3EKN\u001c'/\u001b9u_J\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\tYc\n\u0003\u0004U\u0001\u0001\u0006IaQ\u0001\u000bgR\fG/\u001a#fg\u000e\u0004\u0003b\u0002,\u0001\u0005\u0004%IaV\u0001\u0011G2,\u0017M\\;q'R\fG/\u001a#fg\u000e,\u0012\u0001\u0017\t\u0004\tfc\u0015B\u0001.F\u0005Q1\u0016\r\\;f'R\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\"1A\f\u0001Q\u0001\na\u000b\u0011c\u00197fC:,\bo\u0015;bi\u0016$Um]2!\u0011\u0015q\u0006\u0001\"\u0011`\u0003!\u0019\u0017M\\'fe\u001e,G#A\u001e\t\u000b\u0005\u0004A\u0011\t2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0019\t\u0003I\u001et!\u0001H3\n\u0005\u0019l\u0012A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u000f\t\u000b-\u0004A\u0011\t7\u0002\u0013=tW\t\\3nK:$H#B7qeR4\bCA\to\u0013\ty'CA\u0007Ue&<w-\u001a:SKN,H\u000e\u001e\u0005\u0006c*\u0004\raG\u0001\bK2,W.\u001a8u\u0011\u0015\u0019(\u000e1\u0001*\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0003vU\u0002\u0007\u0011%\u0001\u0004xS:$wn\u001e\u0005\u0006o*\u0004\r\u0001_\u0001\u0004GRD\bcA=\u0002\u001c9\u0019!0a\u0006\u000f\u0007m\f)BD\u0002}\u0003'q1!`A\t\u001d\rq\u0018q\u0002\b\u0004\u007f\u00065a\u0002BA\u0001\u0003\u0017qA!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fq\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011\u0001\u0004C\u0005\u0003-]I!\u0001F\u000b\n\u0005\r\u0019\u0012bAA\r%\u00059AK]5hO\u0016\u0014\u0018\u0002BA\u000f\u0003?\u0011a\u0002\u0016:jO\u001e,'oQ8oi\u0016DHOC\u0002\u0002\u001aIAq!a\t\u0001\t\u0003\n)#\u0001\tp]B\u0013xnY3tg&tw\rV5nKR9Q.a\n\u0002,\u00055\u0002bBA\u0015\u0003C\u0001\r!K\u0001\u0005i&lW\r\u0003\u0004v\u0003C\u0001\r!\t\u0005\u0007o\u0006\u0005\u0002\u0019\u0001=\t\u000f\u0005E\u0002\u0001\"\u0011\u00024\u0005YqN\\#wK:$H+[7f)\u001di\u0017QGA\u001c\u0003sAq!!\u000b\u00020\u0001\u0007\u0011\u0006\u0003\u0004v\u0003_\u0001\r!\t\u0005\u0007o\u0006=\u0002\u0019\u0001=\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\u0005)1\r\\3beR1\u0011\u0011IA$\u0003\u0013\u00022\u0001HA\"\u0013\r\t)%\b\u0002\u0005+:LG\u000f\u0003\u0004v\u0003w\u0001\r!\t\u0005\u0007o\u0006m\u0002\u0019\u0001=\b\u000f\u00055#\u0001#\u0001\u0002P\u0005I2\u000b^1uK\u000ecW-\u00198j]\u001e\u001cu.\u001e8u)JLwmZ3s!\r!\u0014\u0011\u000b\u0004\u0007\u0003\tA\t!a\u0015\u0014\r\u0005E\u0013QKA.!\ra\u0012qK\u0005\u0004\u00033j\"AB!osJ+g\rE\u0002\u001d\u0003;J1!a\u0018\u001e\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\t\u0014\u0011\u000bC\u0001\u0003G\"\"!a\u0014\t\u0011\u0005\u001d\u0014\u0011\u000bC\u0001\u0003S\n!a\u001c4\u0015\u000bM\nY'!\u001f\t\u0011\u00055\u0014Q\ra\u0001\u0003_\naaY8oM&<\u0007\u0003BA9\u0003kj!!a\u001d\u000b\u0005Y1\u0011\u0002BA<\u0003g\u00121\u0002V1cY\u0016\u001cuN\u001c4jO\"1q&!\u001aA\u0002%2q!! \u0002R\u0001\tyHA\u0002Tk6\u001cb!a\u001f\u0002\u0002\u0006\u001d\u0005cA'\u0002\u0004&\u0019\u0011Q\u0011(\u0003\r=\u0013'.Z2u!\u0015\tI)a$M\u001b\t\tYIC\u0002\u0002\u000e\u001e\u000b\u0011BZ;oGRLwN\\:\n\t\u0005E\u00151\u0012\u0002\u000f%\u0016$WoY3Gk:\u001cG/[8o\u0011\u001d\t\u00141\u0010C\u0001\u0003+#\"!a&\u0011\t\u0005e\u00151P\u0007\u0003\u0003#B\u0001\"!(\u0002|\u0011\u0005\u0013qT\u0001\u0007e\u0016$WoY3\u0015\u000b1\u000b\t+!*\t\u000f\u0005\r\u00161\u0014a\u0001\u0019\u00061a/\u00197vKFBq!a*\u0002\u001c\u0002\u0007A*\u0001\u0004wC2,XM\r\u0005\u000b\u0003W\u000b\t&!A\u0005\n\u00055\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!!")
public class StateCleaningCountTrigger
extends Trigger<Object, GlobalWindow> {
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final long maxCount;
    private final boolean stateCleaningEnabled;
    private final ReducingStateDescriptor<Long> stateDesc;
    private final ValueStateDescriptor<Long> cleanupStateDesc;

    public static StateCleaningCountTrigger of(TableConfig tableConfig, long l) {
        return StateCleaningCountTrigger$.MODULE$.of(tableConfig, l);
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    private ReducingStateDescriptor<Long> stateDesc() {
        return this.stateDesc;
    }

    private ValueStateDescriptor<Long> cleanupStateDesc() {
        return this.cleanupStateDesc;
    }

    public boolean canMerge() {
        return false;
    }

    public String toString() {
        return new StringBuilder().append((Object)"CountTriggerGlobalWindowithCleanupState(minIdleStateRetentionTime=").append((Object)BoxesRunTime.boxToLong((long)this.minRetentionTime)).append((Object)", ").append((Object)"maxIdleStateRetentionTime=").append((Object)BoxesRunTime.boxToLong((long)this.maxRetentionTime)).append((Object)", ").append((Object)"maxCount=").append((Object)BoxesRunTime.boxToLong((long)this.maxCount)).append((Object)")").toString();
    }

    public TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
        TriggerResult triggerResult;
        Long curCleanupTime;
        long currentTime = ctx.getCurrentProcessingTime();
        if (this.stateCleaningEnabled() && ((curCleanupTime = (Long)((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).value()) == null || currentTime + this.minRetentionTime > Predef$.MODULE$.Long2long(curCleanupTime))) {
            long cleanupTime = currentTime + this.maxRetentionTime;
            ctx.registerProcessingTimeTimer(cleanupTime);
            if (curCleanupTime != null) {
                ctx.deleteProcessingTimeTimer(Predef$.MODULE$.Long2long(curCleanupTime));
            }
            ((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).update((Object)Predef$.MODULE$.long2Long(cleanupTime));
        }
        ReducingState count = (ReducingState)ctx.getPartitionedState(this.stateDesc());
        count.add((Object)Predef$.MODULE$.long2Long(1L));
        if (Predef$.MODULE$.Long2long((Long)count.get()) >= this.maxCount) {
            count.clear();
            triggerResult = TriggerResult.FIRE;
        } else {
            triggerResult = TriggerResult.CONTINUE;
        }
        return triggerResult;
    }

    public TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        if (this.stateCleaningEnabled()) {
            this.clear(window, ctx);
            return TriggerResult.FIRE_AND_PURGE;
        }
        return TriggerResult.CONTINUE;
    }

    public TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        return TriggerResult.CONTINUE;
    }

    public void clear(GlobalWindow window, Trigger.TriggerContext ctx) {
        ctx.getPartitionedState(this.stateDesc()).clear();
        ctx.getPartitionedState(this.cleanupStateDesc()).clear();
    }

    public StateCleaningCountTrigger(long minRetentionTime, long maxRetentionTime, long maxCount) {
        this.minRetentionTime = minRetentionTime;
        this.maxRetentionTime = maxRetentionTime;
        this.maxCount = maxCount;
        this.stateCleaningEnabled = minRetentionTime > 1L;
        this.stateDesc = new ReducingStateDescriptor("count", (ReduceFunction)new Sum(), Types.LONG());
        this.cleanupStateDesc = new ValueStateDescriptor("countCleanup", Types.LONG());
    }

    public static class Sum
    implements ReduceFunction<Long> {
        public Long reduce(Long value1, Long value2) {
            return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(value1) + Predef$.MODULE$.Long2long(value2));
        }
    }
}

