/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sqlexec;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlAlterDatabase;
import org.apache.flink.sql.parser.ddl.SqlAlterFunction;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTableOptions;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRename;
import org.apache.flink.sql.parser.ddl.SqlCreateDatabase;
import org.apache.flink.sql.parser.ddl.SqlCreateFunction;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.ddl.SqlDropDatabase;
import org.apache.flink.sql.parser.ddl.SqlDropFunction;
import org.apache.flink.sql.parser.ddl.SqlDropTable;
import org.apache.flink.sql.parser.ddl.SqlDropView;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.SqlUseCatalog;
import org.apache.flink.sql.parser.ddl.SqlUseDatabase;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.dql.SqlRichDescribeTable;
import org.apache.flink.sql.parser.dql.SqlRichExplain;
import org.apache.flink.sql.parser.dql.SqlShowCatalogs;
import org.apache.flink.sql.parser.dql.SqlShowCurrentCatalog;
import org.apache.flink.sql.parser.dql.SqlShowCurrentDatabase;
import org.apache.flink.sql.parser.dql.SqlShowDatabases;
import org.apache.flink.sql.parser.dql.SqlShowFunctions;
import org.apache.flink.sql.parser.dql.SqlShowTables;
import org.apache.flink.sql.parser.dql.SqlShowViews;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowCurrentCatalogOperation;
import org.apache.flink.table.operations.ShowCurrentDatabaseOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.StringUtils;

public class SqlToOperationConverter {
    private FlinkPlannerImpl flinkPlanner;
    private CatalogManager catalogManager;

    private SqlToOperationConverter(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager) {
        this.flinkPlanner = flinkPlanner;
        this.catalogManager = catalogManager;
    }

    public static Optional<Operation> convert(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager, SqlNode sqlNode) {
        SqlNode validated = flinkPlanner.validate(sqlNode);
        SqlToOperationConverter converter = new SqlToOperationConverter(flinkPlanner, catalogManager);
        if (validated instanceof SqlUseCatalog) {
            return Optional.of(converter.convertUseCatalog((SqlUseCatalog)validated));
        }
        if (validated instanceof SqlShowCatalogs) {
            return Optional.of(converter.convertShowCatalogs((SqlShowCatalogs)validated));
        }
        if (validated instanceof SqlShowCurrentCatalog) {
            return Optional.of(converter.convertShowCurrentCatalog((SqlShowCurrentCatalog)validated));
        }
        if (validated instanceof SqlCreateDatabase) {
            return Optional.of(converter.convertCreateDatabase((SqlCreateDatabase)validated));
        }
        if (validated instanceof SqlDropDatabase) {
            return Optional.of(converter.convertDropDatabase((SqlDropDatabase)validated));
        }
        if (validated instanceof SqlAlterDatabase) {
            return Optional.of(converter.convertAlterDatabase((SqlAlterDatabase)validated));
        }
        if (validated instanceof SqlShowDatabases) {
            return Optional.of(converter.convertShowDatabases((SqlShowDatabases)validated));
        }
        if (validated instanceof SqlShowCurrentDatabase) {
            return Optional.of(converter.convertShowCurrentDatabase((SqlShowCurrentDatabase)validated));
        }
        if (validated instanceof SqlUseDatabase) {
            return Optional.of(converter.convertUseDatabase((SqlUseDatabase)validated));
        }
        if (validated instanceof SqlCreateTable) {
            return Optional.of(converter.convertCreateTable((SqlCreateTable)validated));
        }
        if (validated instanceof SqlDropTable) {
            return Optional.of(converter.convertDropTable((SqlDropTable)validated));
        }
        if (validated instanceof SqlAlterTable) {
            return Optional.of(converter.convertAlterTable((SqlAlterTable)validated));
        }
        if (validated instanceof SqlShowTables) {
            return Optional.of(converter.convertShowTables((SqlShowTables)validated));
        }
        if (validated instanceof SqlCreateView) {
            return Optional.of(converter.convertCreateView((SqlCreateView)validated));
        }
        if (validated instanceof SqlDropView) {
            return Optional.of(converter.convertDropView((SqlDropView)validated));
        }
        if (validated instanceof SqlShowViews) {
            return Optional.of(converter.convertShowViews((SqlShowViews)validated));
        }
        if (validated instanceof SqlCreateFunction) {
            return Optional.of(converter.convertCreateFunction((SqlCreateFunction)validated));
        }
        if (validated instanceof SqlAlterFunction) {
            return Optional.of(converter.convertAlterFunction((SqlAlterFunction)validated));
        }
        if (validated instanceof SqlDropFunction) {
            return Optional.of(converter.convertDropFunction((SqlDropFunction)validated));
        }
        if (validated instanceof SqlShowFunctions) {
            return Optional.of(converter.convertShowFunctions((SqlShowFunctions)validated));
        }
        if (validated instanceof SqlRichExplain) {
            return Optional.of(converter.convertRichExplain((SqlRichExplain)validated));
        }
        if (validated instanceof SqlRichDescribeTable) {
            return Optional.of(converter.convertDescribeTable((SqlRichDescribeTable)validated));
        }
        if (validated instanceof RichSqlInsert) {
            SqlNodeList targetColumnList = ((RichSqlInsert)validated).getTargetColumnList();
            if (targetColumnList != null && targetColumnList.size() != 0) {
                throw new ValidationException("Partial inserts are not supported");
            }
            return Optional.of(converter.convertSqlInsert((RichSqlInsert)validated));
        }
        if (validated.getKind().belongsTo(SqlKind.QUERY)) {
            return Optional.of(converter.convertSqlQuery(validated));
        }
        return Optional.empty();
    }

    private Operation convertCreateTable(SqlCreateTable sqlCreateTable) {
        if (sqlCreateTable.getFullConstraints().size() > 0) {
            throw new TableException("Primary key and unique key are not supported yet.");
        }
        if (sqlCreateTable.getWatermark().isPresent()) {
            throw new TableException("Watermark statement is not supported in Old Planner, please use Blink Planner instead.");
        }
        if (sqlCreateTable.getTableLike().isPresent()) {
            throw new TableException("CREATE TABLE ... LIKE statement is not supported in Old Planner, please use Blink Planner instead.");
        }
        HashMap properties = new HashMap();
        sqlCreateTable.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        TableSchema tableSchema = this.createTableSchema(sqlCreateTable);
        String tableComment = sqlCreateTable.getComment().map(comment -> comment.getNlsString().getValue()).orElse(null);
        List<String> partitionKeys = sqlCreateTable.getPartitionKeyList().getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
        this.verifyPartitioningColumnsExist(tableSchema, partitionKeys);
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, partitionKeys, properties, tableComment);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateTableOperation(identifier, (CatalogTable)catalogTable, sqlCreateTable.isIfNotExists(), sqlCreateTable.isTemporary());
    }

    private void verifyPartitioningColumnsExist(TableSchema mergedSchema, List<String> partitionKeys) {
        for (String partitionKey : partitionKeys) {
            if (mergedSchema.getTableColumn(partitionKey).isPresent()) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the table schema. Available columns: [%s]", partitionKey, Arrays.stream(mergedSchema.getFieldNames()).collect(Collectors.joining("', '", "'", "'"))));
        }
    }

    private Operation convertDropTable(SqlDropTable sqlDropTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropTableOperation(identifier, sqlDropTable.getIfExists(), sqlDropTable.isTemporary());
    }

    private Operation convertAlterTable(SqlAlterTable sqlAlterTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterTable.fullTableName());
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        if (sqlAlterTable instanceof SqlAlterTableRename) {
            UnresolvedIdentifier newUnresolvedIdentifier = UnresolvedIdentifier.of((String[])((SqlAlterTableRename)sqlAlterTable).fullNewTableName());
            ObjectIdentifier newTableIdentifier = this.catalogManager.qualifyIdentifier(newUnresolvedIdentifier);
            return new AlterTableRenameOperation(tableIdentifier, newTableIdentifier);
        }
        if (sqlAlterTable instanceof SqlAlterTableOptions) {
            Optional optionalCatalogTable = this.catalogManager.getTable(tableIdentifier);
            if (optionalCatalogTable.isPresent() && !((CatalogManager.TableLookupResult)optionalCatalogTable.get()).isTemporary()) {
                CatalogTable originalCatalogTable = (CatalogTable)((CatalogManager.TableLookupResult)optionalCatalogTable.get()).getTable();
                HashMap options = new HashMap();
                options.putAll(originalCatalogTable.getOptions());
                ((SqlAlterTableOptions)sqlAlterTable).getPropertyList().getList().forEach(p -> options.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
                return new AlterTableOptionsOperation(tableIdentifier, originalCatalogTable.copy(options));
            }
            throw new ValidationException(String.format("Table %s doesn't exist or is a temporary table.", tableIdentifier.toString()));
        }
        throw new ValidationException(String.format("[%s] needs to implement", sqlAlterTable.toSqlString(CalciteSqlDialect.DEFAULT)));
    }

    private Operation convertCreateFunction(SqlCreateFunction sqlCreateFunction) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateFunction.getFunctionIdentifier());
        if (sqlCreateFunction.isSystemFunction()) {
            return new CreateTempSystemFunctionOperation(unresolvedIdentifier.getObjectName(), sqlCreateFunction.getFunctionClassName().getValueAs(String.class), sqlCreateFunction.isIfNotExists(), this.parseLanguage(sqlCreateFunction.getFunctionLanguage()));
        }
        FunctionLanguage language = this.parseLanguage(sqlCreateFunction.getFunctionLanguage());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(sqlCreateFunction.getFunctionClassName().getValueAs(String.class), language);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateCatalogFunctionOperation(identifier, (CatalogFunction)catalogFunction, sqlCreateFunction.isIfNotExists(), sqlCreateFunction.isTemporary());
    }

    private Operation convertAlterFunction(SqlAlterFunction sqlAlterFunction) {
        if (sqlAlterFunction.isSystemFunction()) {
            throw new ValidationException("Alter temporary system function is not supported");
        }
        FunctionLanguage language = this.parseLanguage(sqlAlterFunction.getFunctionLanguage());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(sqlAlterFunction.getFunctionClassName().getValueAs(String.class), language);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterFunction.getFunctionIdentifier());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new AlterCatalogFunctionOperation(identifier, (CatalogFunction)catalogFunction, sqlAlterFunction.isIfExists(), sqlAlterFunction.isTemporary());
    }

    private Operation convertDropFunction(SqlDropFunction sqlDropFunction) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropFunction.getFunctionIdentifier());
        if (sqlDropFunction.isSystemFunction()) {
            return new DropTempSystemFunctionOperation(unresolvedIdentifier.getObjectName(), sqlDropFunction.getIfExists());
        }
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropCatalogFunctionOperation(identifier, sqlDropFunction.getIfExists(), sqlDropFunction.isTemporary());
    }

    private Operation convertSqlQuery(SqlNode node) {
        return this.toQueryOperation(this.flinkPlanner, node);
    }

    private Operation convertSqlInsert(RichSqlInsert insert) {
        ImmutableList<String> targetTablePath = ((SqlIdentifier)insert.getTargetTable()).names;
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(targetTablePath);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        PlannerQueryOperation query = (PlannerQueryOperation)SqlToOperationConverter.convert(this.flinkPlanner, this.catalogManager, insert.getSource()).orElseThrow(() -> new TableException("Unsupported node type " + insert.getSource().getClass().getSimpleName()));
        return new CatalogSinkModifyOperation(identifier, (QueryOperation)query, insert.getStaticPartitionKVs(), insert.isOverwrite(), Collections.emptyMap());
    }

    private Operation convertUseCatalog(SqlUseCatalog useCatalog) {
        return new UseCatalogOperation(useCatalog.catalogName());
    }

    private Operation convertUseDatabase(SqlUseDatabase useDatabase) {
        String[] fullDatabaseName = useDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("use database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 2 ? fullDatabaseName[0] : this.catalogManager.getCurrentCatalog();
        String databaseName = fullDatabaseName.length == 2 ? fullDatabaseName[1] : fullDatabaseName[0];
        return new UseDatabaseOperation(catalogName, databaseName);
    }

    private Operation convertCreateDatabase(SqlCreateDatabase sqlCreateDatabase) {
        String[] fullDatabaseName = sqlCreateDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("create database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        boolean ignoreIfExists = sqlCreateDatabase.isIfNotExists();
        String databaseComment = sqlCreateDatabase.getComment().map(comment -> comment.getNlsString().getValue()).orElse(null);
        HashMap properties = new HashMap();
        sqlCreateDatabase.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(properties, databaseComment);
        return new CreateDatabaseOperation(catalogName, databaseName, (CatalogDatabase)catalogDatabase, ignoreIfExists);
    }

    private Operation convertDropDatabase(SqlDropDatabase sqlDropDatabase) {
        String[] fullDatabaseName = sqlDropDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("drop database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        return new DropDatabaseOperation(catalogName, databaseName, sqlDropDatabase.getIfExists(), sqlDropDatabase.isCascade());
    }

    private Operation convertAlterDatabase(SqlAlterDatabase sqlAlterDatabase) {
        CatalogDatabase originCatalogDatabase;
        String[] fullDatabaseName = sqlAlterDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new ValidationException("alter database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        HashMap properties = new HashMap();
        Optional catalog = this.catalogManager.getCatalog(catalogName);
        if (catalog.isPresent()) {
            try {
                originCatalogDatabase = ((Catalog)catalog.get()).getDatabase(databaseName);
                properties.putAll(originCatalogDatabase.getProperties());
            }
            catch (DatabaseNotExistException e) {
                throw new ValidationException(String.format("Database %s not exists", databaseName), (Throwable)e);
            }
        } else {
            throw new ValidationException(String.format("Catalog %s not exists", catalogName));
        }
        sqlAlterDatabase.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(properties, originCatalogDatabase.getComment());
        return new AlterDatabaseOperation(catalogName, databaseName, (CatalogDatabase)catalogDatabase);
    }

    private Operation convertShowCatalogs(SqlShowCatalogs sqlShowCatalogs) {
        return new ShowCatalogsOperation();
    }

    private Operation convertShowCurrentCatalog(SqlShowCurrentCatalog sqlShowCurrentCatalog) {
        return new ShowCurrentCatalogOperation();
    }

    private Operation convertShowDatabases(SqlShowDatabases sqlShowDatabases) {
        return new ShowDatabasesOperation();
    }

    private Operation convertShowCurrentDatabase(SqlShowCurrentDatabase sqlShowCurrentDatabase) {
        return new ShowCurrentDatabaseOperation();
    }

    private Operation convertShowTables(SqlShowTables sqlShowTables) {
        return new ShowTablesOperation();
    }

    private Operation convertShowFunctions(SqlShowFunctions sqlShowFunctions) {
        return new ShowFunctionsOperation(sqlShowFunctions.requireUser() ? ShowFunctionsOperation.FunctionScope.USER : ShowFunctionsOperation.FunctionScope.ALL);
    }

    private Operation convertCreateView(SqlCreateView sqlCreateView) {
        SqlNode query = sqlCreateView.getQuery();
        SqlNodeList fieldList = sqlCreateView.getFieldList();
        SqlNode validateQuery = this.flinkPlanner.validate(query);
        PlannerQueryOperation operation = this.toQueryOperation(this.flinkPlanner, validateQuery);
        ResolvedSchema schema = operation.getResolvedSchema();
        if (!fieldList.getList().isEmpty()) {
            List inputFieldNames = schema.getColumnNames();
            List aliasFieldNames = fieldList.getList().stream().map(SqlNode::toString).collect(Collectors.toList());
            if (inputFieldNames.size() != aliasFieldNames.size()) {
                throw new ValidationException(String.format("VIEW definition and input fields not match:\n\tDef fields: %s.\n\tInput fields: %s.", aliasFieldNames, inputFieldNames));
            }
            schema = ResolvedSchema.physical(aliasFieldNames, (List)schema.getColumnDataTypes());
        }
        String originalQuery = this.getQuotedSqlString(query);
        String expandedQuery = this.getQuotedSqlString(validateQuery);
        String comment = sqlCreateView.getComment().map(c -> c.getNlsString().getValue()).orElse(null);
        CatalogView catalogView = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)comment, (String)originalQuery, (String)expandedQuery, Collections.emptyMap());
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateView.fullViewName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateViewOperation(identifier, catalogView, sqlCreateView.isIfNotExists(), sqlCreateView.isTemporary());
    }

    private Operation convertDropView(SqlDropView sqlDropView) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropView.fullViewName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropViewOperation(identifier, sqlDropView.getIfExists(), sqlDropView.isTemporary());
    }

    private Operation convertShowViews(SqlShowViews sqlShowViews) {
        return new ShowViewsOperation();
    }

    private Operation convertRichExplain(SqlRichExplain sqlExplain) {
        Operation operation = this.convertSqlQuery(sqlExplain.getStatement());
        return new ExplainOperation(operation);
    }

    private Operation convertDescribeTable(SqlRichDescribeTable sqlRichDescribeTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlRichDescribeTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DescribeTableOperation(identifier, sqlRichDescribeTable.isExtended());
    }

    private TableSchema createTableSchema(SqlCreateTable sqlCreateTable) {
        if (!sqlCreateTable.hasRegularColumnsOnly()) {
            throw new TableException("Only regular columns are supported in the DDL of the old planner.");
        }
        TableSchema.Builder builder = new TableSchema.Builder();
        SqlNodeList columnList = sqlCreateTable.getColumnList();
        List physicalColumns = columnList.getList().stream().filter(SqlTableColumn.SqlRegularColumn.class::isInstance).map(SqlTableColumn.SqlRegularColumn.class::cast).collect(Collectors.toList());
        for (SqlTableColumn.SqlRegularColumn regularColumn : physicalColumns) {
            SqlDataTypeSpec type = regularColumn.getType();
            boolean nullable = type.getNullable() == null ? true : type.getNullable();
            RelDataType relType = regularColumn.getType().deriveType(this.flinkPlanner.getOrCreateSqlValidator(), nullable);
            builder.field(regularColumn.getName().getSimple(), TypeConversions.fromLegacyInfoToDataType(FlinkTypeFactory.toTypeInfo(relType)));
        }
        return builder.build();
    }

    private FunctionLanguage parseLanguage(String languageString) {
        FunctionLanguage language;
        if (StringUtils.isNullOrWhitespaceOnly((String)languageString)) {
            return FunctionLanguage.JAVA;
        }
        try {
            language = FunctionLanguage.valueOf((String)languageString);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("Unrecognized function language string %s", languageString), e);
        }
        return language;
    }

    private PlannerQueryOperation toQueryOperation(FlinkPlannerImpl planner, SqlNode validated) {
        RelRoot relational = planner.rel(validated);
        return new PlannerQueryOperation(relational.rel);
    }

    private String getQuotedSqlString(SqlNode sqlNode) {
        SqlParser.Config parserConfig = this.flinkPlanner.config().getParserConfig();
        CalciteSqlDialect dialect = new CalciteSqlDialect(SqlDialect.EMPTY_CONTEXT.withQuotedCasing(parserConfig.unquotedCasing()).withConformance(parserConfig.conformance()).withUnquotedCasing(parserConfig.unquotedCasing()).withIdentifierQuoteString(parserConfig.quoting().string));
        return sqlNode.toSqlString(dialect).getSql();
    }
}

