/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.flink.util.TestSignalHandler;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogger {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Rule
    public TestRule watchman = new TestWatcher(){

        public void starting(Description description) {
            TestLogger.this.log.info("\n================================================================================\nTest {} is running.\n--------------------------------------------------------------------------------", (Object)description);
        }

        public void succeeded(Description description) {
            TestLogger.this.log.info("\n--------------------------------------------------------------------------------\nTest {} successfully run.\n================================================================================", (Object)description);
        }

        public void failed(Throwable e, Description description) {
            TestLogger.this.log.error("\n--------------------------------------------------------------------------------\nTest {} failed with:\n{}\n================================================================================", (Object)description, (Object)TestLogger.exceptionToString(e));
        }
    };

    private static String exceptionToString(Throwable t) {
        if (t == null) {
            return "(null)";
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            t.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable ignored) {
            return t.getClass().getName() + " (error while printing stack trace)";
        }
    }

    static {
        TestSignalHandler.register();
    }
}

