/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.metadata.namingserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.util.CollectionUtils;

public class Instance {
    private String namespace;
    private String clusterName;
    private String unit;
    private Node.Endpoint control = new Node.Endpoint();
    private Node.Endpoint transaction = new Node.Endpoint();
    private double weight = 1.0;
    private boolean healthy = true;
    private long term;
    private long timestamp;
    private ClusterRole role = ClusterRole.MEMBER;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    private Instance() {
    }

    public static Instance getInstance() {
        return SingletonHolder.SERVER_INSTANCE;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public ClusterRole getRole() {
        return this.role;
    }

    public void setRole(ClusterRole role) {
        this.role = role;
    }

    public Node.Endpoint getControl() {
        return this.control;
    }

    public void setControl(Node.Endpoint control) {
        this.control = control;
    }

    public Node.Endpoint getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Node.Endpoint transaction) {
        this.transaction = transaction;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public int hashCode() {
        return Objects.hash(this.control, this.transaction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        return Objects.equals(this.control, instance.control) && Objects.equals(this.transaction, instance.transaction);
    }

    public String toJsonString(ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> toMap() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("namespace", this.namespace);
        resultMap.put("clusterName", this.clusterName);
        resultMap.put("unit", this.unit);
        resultMap.put("control", this.control.toString());
        resultMap.put("transaction", this.transaction.toString());
        resultMap.put("weight", String.valueOf(this.weight));
        resultMap.put("healthy", String.valueOf(this.healthy));
        resultMap.put("term", String.valueOf(this.term));
        resultMap.put("timestamp", String.valueOf(this.timestamp));
        resultMap.put("metadata", CollectionUtils.mapToJsonString(this.metadata));
        return resultMap;
    }

    private static class SingletonHolder {
        private static final Instance SERVER_INSTANCE = new Instance();

        private SingletonHolder() {
        }
    }
}

