/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer;

import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.SQLNodeConverterEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingSphereOptimizer {
    private final SqlToRelConverter converter;
    private final RelOptPlanner hepPlannerWithoutCalc;
    private final RelOptPlanner hepPlannerWithCalc;

    public RelNode optimize(SQLStatement sqlStatement) {
        SqlNode sqlNode = SQLNodeConverterEngine.convert(sqlStatement);
        RelNode logicPlan = this.converter.convertQuery((SqlNode)sqlNode, (boolean)true, (boolean)true).rel;
        RelNode ruleBasedPlan = ShardingSphereOptimizer.optimizeWithRBO(logicPlan, this.hepPlannerWithoutCalc);
        RelNode costBasedPlan = this.optimizeWithCBO(ruleBasedPlan, this.converter);
        return ShardingSphereOptimizer.optimizeWithRBO(costBasedPlan, this.hepPlannerWithCalc);
    }

    private static RelNode optimizeWithRBO(RelNode logicPlan, RelOptPlanner hepPlanner) {
        hepPlanner.setRoot(logicPlan);
        return hepPlanner.findBestExp();
    }

    private RelNode optimizeWithCBO(RelNode bestPlan, SqlToRelConverter converter) {
        RelOptPlanner planner = converter.getCluster().getPlanner();
        if (!bestPlan.getTraitSet().equals((Object)converter.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE))) {
            planner.setRoot(planner.changeTraits(bestPlan, converter.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE)));
        } else {
            planner.setRoot(bestPlan);
        }
        return planner.findBestExp();
    }

    @Generated
    public ShardingSphereOptimizer(SqlToRelConverter converter, RelOptPlanner hepPlannerWithoutCalc, RelOptPlanner hepPlannerWithCalc) {
        this.converter = converter;
        this.hepPlannerWithoutCalc = hepPlannerWithoutCalc;
        this.hepPlannerWithCalc = hepPlannerWithCalc;
    }
}

