/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.from.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;

public final class SimpleTableConverter
implements SQLSegmentConverter<SimpleTableSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convert(SimpleTableSegment segment) {
        TableNameSegment tableName = segment.getTableName();
        ArrayList<String> names = new ArrayList<String>();
        if (segment.getOwner().isPresent()) {
            names.add(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue());
        }
        names.add(tableName.getIdentifier().getValue());
        SqlIdentifier tableNameSQLNode = new SqlIdentifier(names, SqlParserPos.ZERO);
        if (segment.getAlias().isPresent()) {
            SqlIdentifier aliasSQLNode = new SqlIdentifier((String)segment.getAlias().get(), SqlParserPos.ZERO);
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, Arrays.asList(tableNameSQLNode, aliasSQLNode), SqlParserPos.ZERO));
        }
        return Optional.of(tableNameSQLNode);
    }
}

