/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfInt;
import org.opencv.core.Scalar;
import org.opencv.dnn.DictValue;
import org.opencv.dnn.Layer;
import org.opencv.utils.Converters;

public class Net {
    protected final long nativeObj;

    protected Net(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Net __fromPtr__(long addr) {
        return new Net(addr);
    }

    public Net() {
        this.nativeObj = Net.Net_0();
    }

    public Mat forward(String outputName) {
        return new Mat(Net.forward_0(this.nativeObj, outputName));
    }

    public Mat forward() {
        return new Mat(Net.forward_1(this.nativeObj));
    }

    public Mat getParam(DictValue layer, int numParam) {
        return new Mat(Net.getParam_0(this.nativeObj, layer.getNativeObjAddr(), numParam));
    }

    public Mat getParam(DictValue layer) {
        return new Mat(Net.getParam_1(this.nativeObj, layer.getNativeObjAddr()));
    }

    public static Net readFromModelOptimizer(String xml, String bin) {
        return new Net(Net.readFromModelOptimizer_0(xml, bin));
    }

    public Layer getLayer(DictValue layerId) {
        return Layer.__fromPtr__(Net.getLayer_0(this.nativeObj, layerId.getNativeObjAddr()));
    }

    public String dump() {
        return Net.dump_0(this.nativeObj);
    }

    public boolean empty() {
        return Net.empty_0(this.nativeObj);
    }

    public int getLayerId(String layer) {
        return Net.getLayerId_0(this.nativeObj, layer);
    }

    public int getLayersCount(String layerType) {
        return Net.getLayersCount_0(this.nativeObj, layerType);
    }

    public long getFLOPS(MatOfInt netInputShape) {
        MatOfInt netInputShape_mat = netInputShape;
        return Net.getFLOPS_0(this.nativeObj, netInputShape_mat.nativeObj);
    }

    public long getFLOPS(int layerId, MatOfInt netInputShape) {
        MatOfInt netInputShape_mat = netInputShape;
        return Net.getFLOPS_1(this.nativeObj, layerId, netInputShape_mat.nativeObj);
    }

    public long getFLOPS(int layerId, List<MatOfInt> netInputShapes) {
        return Net.getFLOPS_2(this.nativeObj, layerId, netInputShapes);
    }

    public long getFLOPS(List<MatOfInt> netInputShapes) {
        return Net.getFLOPS_3(this.nativeObj, netInputShapes);
    }

    public long getPerfProfile(MatOfDouble timings) {
        MatOfDouble timings_mat = timings;
        return Net.getPerfProfile_0(this.nativeObj, timings_mat.nativeObj);
    }

    public List<String> getLayerNames() {
        return Net.getLayerNames_0(this.nativeObj);
    }

    public List<String> getUnconnectedOutLayersNames() {
        return Net.getUnconnectedOutLayersNames_0(this.nativeObj);
    }

    public MatOfInt getUnconnectedOutLayers() {
        return MatOfInt.fromNativeAddr(Net.getUnconnectedOutLayers_0(this.nativeObj));
    }

    public void connect(String outPin, String inpPin) {
        Net.connect_0(this.nativeObj, outPin, inpPin);
    }

    public void dumpToFile(String path) {
        Net.dumpToFile_0(this.nativeObj, path);
    }

    public void enableFusion(boolean fusion) {
        Net.enableFusion_0(this.nativeObj, fusion);
    }

    public void forward(List<Mat> outputBlobs, String outputName) {
        Mat outputBlobs_mat = new Mat();
        Net.forward_2(this.nativeObj, outputBlobs_mat.nativeObj, outputName);
        Converters.Mat_to_vector_Mat(outputBlobs_mat, outputBlobs);
        outputBlobs_mat.release();
    }

    public void forward(List<Mat> outputBlobs) {
        Mat outputBlobs_mat = new Mat();
        Net.forward_3(this.nativeObj, outputBlobs_mat.nativeObj);
        Converters.Mat_to_vector_Mat(outputBlobs_mat, outputBlobs);
        outputBlobs_mat.release();
    }

    public void forward(List<Mat> outputBlobs, List<String> outBlobNames) {
        Mat outputBlobs_mat = new Mat();
        Net.forward_4(this.nativeObj, outputBlobs_mat.nativeObj, outBlobNames);
        Converters.Mat_to_vector_Mat(outputBlobs_mat, outputBlobs);
        outputBlobs_mat.release();
    }

    public void getLayerTypes(List<String> layersTypes) {
        Net.getLayerTypes_0(this.nativeObj, layersTypes);
    }

    public void getMemoryConsumption(MatOfInt netInputShape, long[] weights, long[] blobs) {
        MatOfInt netInputShape_mat = netInputShape;
        double[] weights_out = new double[1];
        double[] blobs_out = new double[1];
        Net.getMemoryConsumption_0(this.nativeObj, netInputShape_mat.nativeObj, weights_out, blobs_out);
        if (weights != null) {
            weights[0] = (long)weights_out[0];
        }
        if (blobs != null) {
            blobs[0] = (long)blobs_out[0];
        }
    }

    public void getMemoryConsumption(int layerId, MatOfInt netInputShape, long[] weights, long[] blobs) {
        MatOfInt netInputShape_mat = netInputShape;
        double[] weights_out = new double[1];
        double[] blobs_out = new double[1];
        Net.getMemoryConsumption_1(this.nativeObj, layerId, netInputShape_mat.nativeObj, weights_out, blobs_out);
        if (weights != null) {
            weights[0] = (long)weights_out[0];
        }
        if (blobs != null) {
            blobs[0] = (long)blobs_out[0];
        }
    }

    public void getMemoryConsumption(int layerId, List<MatOfInt> netInputShapes, long[] weights, long[] blobs) {
        double[] weights_out = new double[1];
        double[] blobs_out = new double[1];
        Net.getMemoryConsumption_2(this.nativeObj, layerId, netInputShapes, weights_out, blobs_out);
        if (weights != null) {
            weights[0] = (long)weights_out[0];
        }
        if (blobs != null) {
            blobs[0] = (long)blobs_out[0];
        }
    }

    public void setHalideScheduler(String scheduler) {
        Net.setHalideScheduler_0(this.nativeObj, scheduler);
    }

    public void setInput(Mat blob, String name, double scalefactor, Scalar mean) {
        Net.setInput_0(this.nativeObj, blob.nativeObj, name, scalefactor, mean.val[0], mean.val[1], mean.val[2], mean.val[3]);
    }

    public void setInput(Mat blob, String name, double scalefactor) {
        Net.setInput_1(this.nativeObj, blob.nativeObj, name, scalefactor);
    }

    public void setInput(Mat blob, String name) {
        Net.setInput_2(this.nativeObj, blob.nativeObj, name);
    }

    public void setInput(Mat blob) {
        Net.setInput_3(this.nativeObj, blob.nativeObj);
    }

    public void setInputsNames(List<String> inputBlobNames) {
        Net.setInputsNames_0(this.nativeObj, inputBlobNames);
    }

    public void setParam(DictValue layer, int numParam, Mat blob) {
        Net.setParam_0(this.nativeObj, layer.getNativeObjAddr(), numParam, blob.nativeObj);
    }

    public void setPreferableBackend(int backendId) {
        Net.setPreferableBackend_0(this.nativeObj, backendId);
    }

    public void setPreferableTarget(int targetId) {
        Net.setPreferableTarget_0(this.nativeObj, targetId);
    }

    protected void finalize() throws Throwable {
        Net.delete(this.nativeObj);
    }

    private static native long Net_0();

    private static native long forward_0(long var0, String var2);

    private static native long forward_1(long var0);

    private static native long getParam_0(long var0, long var2, int var4);

    private static native long getParam_1(long var0, long var2);

    private static native long readFromModelOptimizer_0(String var0, String var1);

    private static native long getLayer_0(long var0, long var2);

    private static native String dump_0(long var0);

    private static native boolean empty_0(long var0);

    private static native int getLayerId_0(long var0, String var2);

    private static native int getLayersCount_0(long var0, String var2);

    private static native long getFLOPS_0(long var0, long var2);

    private static native long getFLOPS_1(long var0, int var2, long var3);

    private static native long getFLOPS_2(long var0, int var2, List<MatOfInt> var3);

    private static native long getFLOPS_3(long var0, List<MatOfInt> var2);

    private static native long getPerfProfile_0(long var0, long var2);

    private static native List<String> getLayerNames_0(long var0);

    private static native List<String> getUnconnectedOutLayersNames_0(long var0);

    private static native long getUnconnectedOutLayers_0(long var0);

    private static native void connect_0(long var0, String var2, String var3);

    private static native void dumpToFile_0(long var0, String var2);

    private static native void enableFusion_0(long var0, boolean var2);

    private static native void forward_2(long var0, long var2, String var4);

    private static native void forward_3(long var0, long var2);

    private static native void forward_4(long var0, long var2, List<String> var4);

    private static native void getLayerTypes_0(long var0, List<String> var2);

    private static native void getMemoryConsumption_0(long var0, long var2, double[] var4, double[] var5);

    private static native void getMemoryConsumption_1(long var0, int var2, long var3, double[] var5, double[] var6);

    private static native void getMemoryConsumption_2(long var0, int var2, List<MatOfInt> var3, double[] var4, double[] var5);

    private static native void setHalideScheduler_0(long var0, String var2);

    private static native void setInput_0(long var0, long var2, String var4, double var5, double var7, double var9, double var11, double var13);

    private static native void setInput_1(long var0, long var2, String var4, double var5);

    private static native void setInput_2(long var0, long var2, String var4);

    private static native void setInput_3(long var0, long var2);

    private static native void setInputsNames_0(long var0, List<String> var2);

    private static native void setParam_0(long var0, long var2, int var4, long var5);

    private static native void setPreferableBackend_0(long var0, int var2);

    private static native void setPreferableTarget_0(long var0, int var2);

    private static native void delete(long var0);
}

