/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.fontbox.cmap;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.dromara.pdf.shade.org.apache.fontbox.cmap.CMap;

public class CMapStrings {
    private static final List<String> twoByteMappings = new ArrayList<String>(65536);
    private static final List<String> oneByteMappings = new ArrayList<String>(256);
    private static final List<Integer> indexValues = new ArrayList<Integer>(65536);
    private static final List<byte[]> oneByteValues = new ArrayList<byte[]>(256);
    private static final List<byte[]> twoByteValues = new ArrayList<byte[]>(65536);

    private CMapStrings() {
    }

    private static void fillMappings() {
        int i;
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                byte[] bytes = new byte[]{(byte)i, (byte)j};
                twoByteMappings.add(new String(bytes, StandardCharsets.UTF_16BE));
                twoByteValues.add(bytes);
                indexValues.add(i * 256 + j);
            }
        }
        for (i = 0; i < 256; ++i) {
            byte[] bytes = new byte[]{(byte)i};
            oneByteMappings.add(new String(bytes, StandardCharsets.ISO_8859_1));
            oneByteValues.add(bytes);
        }
    }

    public static String getMapping(byte[] bytes) {
        if (bytes.length > 2) {
            return null;
        }
        return bytes.length == 1 ? oneByteMappings.get(CMap.toInt(bytes)) : twoByteMappings.get(CMap.toInt(bytes));
    }

    public static Integer getIndexValue(byte[] bytes) {
        if (bytes.length > 2) {
            return null;
        }
        return indexValues.get(CMap.toInt(bytes));
    }

    public static byte[] getByteValue(byte[] bytes) {
        if (bytes.length > 2) {
            return null;
        }
        return bytes.length == 1 ? oneByteValues.get(CMap.toInt(bytes)) : twoByteValues.get(CMap.toInt(bytes));
    }

    static {
        CMapStrings.fillMappings();
    }
}

