/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.fontbox.ttf;

import java.io.IOException;
import org.dromara.pdf.shade.org.apache.fontbox.cff.CFFFont;
import org.dromara.pdf.shade.org.apache.fontbox.cff.CFFParser;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.FontHeaders;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TTFDataStream;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TTFTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TrueTypeFont;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessRead;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBuffer;

public class CFFTable
extends TTFTable {
    public static final String TAG = "CFF ";
    private CFFFont cffFont;

    CFFTable() {
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        byte[] bytes = data.read((int)this.getLength());
        CFFParser parser = new CFFParser();
        this.cffFont = parser.parse(bytes, new CFFBytesource(ttf)).get(0);
        this.initialized = true;
    }

    @Override
    void readHeaders(TrueTypeFont ttf, TTFDataStream data, FontHeaders outHeaders) throws IOException {
        try (RandomAccessRead subReader = data.createSubView(this.getLength());){
            RandomAccessRead reader;
            if (subReader != null) {
                reader = subReader;
            } else {
                assert (false) : "It is inefficient to read TTFDataStream into an array";
                byte[] bytes = data.read((int)this.getLength());
                reader = new RandomAccessReadBuffer(bytes);
            }
            new CFFParser().parseFirstSubFontROS(reader, outHeaders);
        }
    }

    public CFFFont getFont() {
        return this.cffFont;
    }

    private static class CFFBytesource
    implements CFFParser.ByteSource {
        private final TrueTypeFont ttf;

        CFFBytesource(TrueTypeFont ttf) {
            this.ttf = ttf;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return this.ttf.getTableBytes(this.ttf.getTableMap().get(CFFTable.TAG));
        }
    }
}

