/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyfCompositeDescript;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyfDescript;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyfSimpleDescript;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyphDescription;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyphRenderer;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyphTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TTFDataStream;
import org.dromara.pdf.shade.org.apache.fontbox.util.BoundingBox;

public class GlyphData {
    private short xMin;
    private short yMin;
    private short xMax;
    private short yMax;
    private BoundingBox boundingBox = null;
    private short numberOfContours;
    private GlyfDescript glyphDescription = null;

    void initData(GlyphTable glyphTable, TTFDataStream data, int leftSideBearing, int level) throws IOException {
        this.numberOfContours = data.readSignedShort();
        this.xMin = data.readSignedShort();
        this.yMin = data.readSignedShort();
        this.xMax = data.readSignedShort();
        this.yMax = data.readSignedShort();
        this.boundingBox = new BoundingBox(this.xMin, this.yMin, this.xMax, this.yMax);
        if (this.numberOfContours >= 0) {
            short x0 = (short)(leftSideBearing - this.xMin);
            this.glyphDescription = new GlyfSimpleDescript(this.numberOfContours, data, x0);
        } else {
            this.glyphDescription = new GlyfCompositeDescript(data, glyphTable, level + 1);
        }
    }

    void initEmptyData() {
        this.glyphDescription = new GlyfSimpleDescript();
        this.boundingBox = new BoundingBox();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public short getNumberOfContours() {
        return this.numberOfContours;
    }

    public GlyphDescription getDescription() {
        return this.glyphDescription;
    }

    public GeneralPath getPath() {
        return new GlyphRenderer(this.glyphDescription).getPath();
    }

    public short getXMaximum() {
        return this.xMax;
    }

    public short getXMinimum() {
        return this.xMin;
    }

    public short getYMaximum() {
        return this.yMax;
    }

    public short getYMinimum() {
        return this.yMin;
    }
}

