/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.CFFTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyphTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TTFDataStream;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TrueTypeFont;

public class OpenTypeFont
extends TrueTypeFont {
    private boolean hasPostScriptTag;

    OpenTypeFont(TTFDataStream fontData) {
        super(fontData);
    }

    @Override
    void setVersion(float versionValue) {
        this.hasPostScriptTag = Float.floatToIntBits(versionValue) == 1184802985;
        super.setVersion(versionValue);
    }

    public CFFTable getCFF() throws IOException {
        if (!this.hasPostScriptTag) {
            throw new UnsupportedOperationException("TTF fonts do not have a CFF table");
        }
        return (CFFTable)this.getTable("CFF ");
    }

    @Override
    public GlyphTable getGlyph() throws IOException {
        if (this.hasPostScriptTag) {
            throw new UnsupportedOperationException("OTF fonts do not have a glyf table");
        }
        return super.getGlyph();
    }

    @Override
    public GeneralPath getPath(String name) throws IOException {
        if (this.hasPostScriptTag && this.isSupportedOTF()) {
            int gid = this.nameToGID(name);
            return this.getCFF().getFont().getType2CharString(gid).getPath();
        }
        return super.getPath(name);
    }

    public boolean isPostScript() {
        return this.hasPostScriptTag || this.tables.containsKey("CFF ") || this.tables.containsKey("CFF2");
    }

    public boolean isSupportedOTF() {
        return !this.hasPostScriptTag || this.tables.containsKey("CFF ") || !this.tables.containsKey("CFF2");
    }

    public boolean hasLayoutTables() {
        return this.tables.containsKey("BASE") || this.tables.containsKey("GDEF") || this.tables.containsKey("GPOS") || this.tables.containsKey("GSUB") || this.tables.containsKey("JSTF");
    }
}

