/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompoundCharacterTokenizer {
    private static final String GLYPH_ID_SEPARATOR = "_";
    private final Pattern regexExpression;

    public CompoundCharacterTokenizer(Set<String> compoundWords) {
        this.validateCompoundWords(compoundWords);
        this.regexExpression = Pattern.compile(this.getRegexFromTokens(compoundWords));
    }

    @Deprecated
    public CompoundCharacterTokenizer(Pattern pattern) {
        this.regexExpression = pattern;
    }

    private void validateCompoundWords(Set<String> compoundWords) {
        if (compoundWords == null || compoundWords.isEmpty()) {
            throw new IllegalArgumentException("Compound words cannot be null or empty");
        }
        compoundWords.forEach(word -> {
            if (!word.startsWith(GLYPH_ID_SEPARATOR) || !word.endsWith(GLYPH_ID_SEPARATOR)) {
                throw new IllegalArgumentException("Compound words should start and end with _");
            }
        });
    }

    public List<String> tokenize(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher regexMatcher = this.regexExpression.matcher(text);
        int lastIndexOfPrevMatch = 0;
        while (regexMatcher.find(lastIndexOfPrevMatch)) {
            int beginIndexOfNextMatch = regexMatcher.start();
            String prevToken = text.substring(lastIndexOfPrevMatch, beginIndexOfNextMatch);
            if (!prevToken.isEmpty()) {
                tokens.add(prevToken);
            }
            String currentMatch = regexMatcher.group();
            tokens.add(currentMatch);
            lastIndexOfPrevMatch = regexMatcher.end();
            if (lastIndexOfPrevMatch >= text.length() || text.charAt(lastIndexOfPrevMatch) == '_') continue;
            --lastIndexOfPrevMatch;
        }
        String tail = text.substring(lastIndexOfPrevMatch);
        if (!tail.isEmpty()) {
            tokens.add(tail);
        }
        return tokens;
    }

    private String getRegexFromTokens(Set<String> compoundWords) {
        StringJoiner sj = new StringJoiner(")|(", "(", ")");
        compoundWords.forEach(sj::add);
        return sj.toString();
    }
}

