/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub.CompoundCharacterTokenizer;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub.GlyphArraySplitter;

public class GlyphArraySplitterRegexImpl
implements GlyphArraySplitter {
    private static final String GLYPH_ID_SEPARATOR = "_";
    private final CompoundCharacterTokenizer compoundCharacterTokenizer;

    public GlyphArraySplitterRegexImpl(Set<List<Integer>> matchers) {
        this.compoundCharacterTokenizer = new CompoundCharacterTokenizer(this.getMatchersAsStrings(matchers));
    }

    @Override
    public List<List<Integer>> split(List<Integer> glyphIds) {
        String originalGlyphsAsText = this.convertGlyphIdsToString(glyphIds);
        List<String> tokens = this.compoundCharacterTokenizer.tokenize(originalGlyphsAsText);
        ArrayList<List<Integer>> modifiedGlyphs = new ArrayList<List<Integer>>(tokens.size());
        tokens.forEach(token -> modifiedGlyphs.add(this.convertGlyphIdsToList((String)token)));
        return modifiedGlyphs;
    }

    private Set<String> getMatchersAsStrings(Set<List<Integer>> matchers) {
        TreeSet<String> stringMatchers = new TreeSet<String>((s1, s2) -> {
            if (s1.length() == s2.length()) {
                return s2.compareTo((String)s1);
            }
            return s2.length() - s1.length();
        });
        matchers.forEach(glyphIds -> stringMatchers.add(this.convertGlyphIdsToString((List<Integer>)glyphIds)));
        return stringMatchers;
    }

    private String convertGlyphIdsToString(List<Integer> glyphIds) {
        StringBuilder sb = new StringBuilder(20);
        sb.append(GLYPH_ID_SEPARATOR);
        glyphIds.forEach(glyphId -> sb.append(glyphId).append(GLYPH_ID_SEPARATOR));
        return sb.toString();
    }

    private List<Integer> convertGlyphIdsToList(String glyphIdsAsString) {
        ArrayList<Integer> gsubProcessedGlyphsIds = new ArrayList<Integer>();
        for (String glyphId : glyphIdsAsString.split(GLYPH_ID_SEPARATOR)) {
            if ((glyphId = glyphId.trim()).isEmpty()) continue;
            gsubProcessedGlyphsIds.add(Integer.valueOf(glyphId));
        }
        return gsubProcessedGlyphsIds;
    }
}

