/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.markedcontent;

import java.io.IOException;
import java.util.List;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.MissingOperandException;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.Operator;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;

public class MarkedContentPointWithProperties
extends OperatorProcessor {
    public MarkedContentPointWithProperties(PDFStreamEngine context) {
        super(context);
    }

    @Override
    public void process(Operator operator, List<COSBase> operands) throws IOException {
        if (operands.size() < 2) {
            throw new MissingOperandException(operator, operands);
        }
        if (!(operands.get(0) instanceof COSName)) {
            return;
        }
        PDFStreamEngine context = this.getContext();
        COSName tag = (COSName)operands.get(0);
        COSBase op1 = operands.get(1);
        COSDictionary propDict = null;
        if (op1 instanceof COSName) {
            PDPropertyList prop = context.getResources().getProperties((COSName)op1);
            if (prop != null) {
                propDict = prop.getCOSObject();
            }
        } else if (op1 instanceof COSDictionary) {
            propDict = (COSDictionary)op1;
        }
        if (propDict == null) {
            return;
        }
        context.markedContentPoint(tag, propDict);
    }

    @Override
    public String getName() {
        return "DP";
    }
}

