/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.ASCIIPane;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.AddressPane;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.HexModel;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.HexPane;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.SelectEvent;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.SelectionChangeListener;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.StatusPane;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.UpperPane;

class HexEditor
extends JPanel
implements SelectionChangeListener {
    private final HexModel model;
    private HexPane hexPane;
    private ASCIIPane asciiPane;
    private AddressPane addressPane;
    private StatusPane statusPane;
    private final Action jumpToIndex = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HexEditor.this.createJumpDialog().setVisible(true);
        }
    };
    private int selectedIndex = -1;

    HexEditor(HexModel model) {
        this.model = model;
        this.createView();
    }

    private void createView() {
        this.setLayout(new GridBagLayout());
        this.addressPane = new AddressPane(this.model.totalLine());
        this.hexPane = new HexPane(this.model);
        this.hexPane.addHexChangeListeners(this.model);
        this.asciiPane = new ASCIIPane(this.model);
        UpperPane upperPane = new UpperPane();
        this.statusPane = new StatusPane();
        this.model.addHexModelChangeListener(this.hexPane);
        this.model.addHexModelChangeListener(this.asciiPane);
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setPreferredSize(new Dimension(990, 20 * (this.model.totalLine() + 1)));
        panel.add(this.addressPane);
        panel.add(this.hexPane);
        panel.add(this.asciiPane);
        JScrollPane scrollPane = this.getScrollPane();
        scrollPane.setViewportView(panel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.weighty = 0.02;
        this.add((Component)upperPane, gbc);
        gbc.anchor = 21;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)scrollPane, gbc);
        gbc.gridy = 2;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.anchor = 25;
        gbc.fill = 2;
        this.add((Component)this.statusPane, gbc);
        this.hexPane.addSelectionChangeListener(this);
        KeyStroke jumpKeyStroke = KeyStroke.getKeyStroke(71, 128);
        this.getInputMap(2).put(jumpKeyStroke, "jump");
        this.getActionMap().put("jump", this.jumpToIndex);
    }

    private JScrollPane getScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        AbstractAction blankAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        scrollPane.getActionMap().put("unitScrollDown", blankAction);
        scrollPane.getActionMap().put("unitScrollLeft", blankAction);
        scrollPane.getActionMap().put("unitScrollRight", blankAction);
        scrollPane.getActionMap().put("unitScrollUp", blankAction);
        JScrollBar verticalScrollBar = scrollPane.createVerticalScrollBar();
        verticalScrollBar.setUnitIncrement(20);
        verticalScrollBar.setBlockIncrement(400);
        verticalScrollBar.setValues(0, 1, 0, 20 * (this.model.totalLine() + 1));
        scrollPane.setVerticalScrollBar(verticalScrollBar);
        return scrollPane;
    }

    @Override
    public void selectionChanged(SelectEvent event) {
        int index = event.getHexIndex();
        switch (event.getNavigation()) {
            case "next": {
                ++index;
                break;
            }
            case "previous": {
                --index;
                break;
            }
            case "up": {
                index -= 16;
                break;
            }
            case "down": {
                index += 16;
                break;
            }
        }
        if (index >= 0 && index <= this.model.size() - 1) {
            this.hexPane.setSelected(index);
            this.addressPane.setSelected(index);
            this.asciiPane.setSelected(index);
            this.statusPane.updateStatus(index);
            this.selectedIndex = index;
        }
    }

    private JDialog createJumpDialog() {
        final JDialog dialog = new JDialog(SwingUtilities.windowForComponent(this), "Jump to index");
        dialog.setLocationRelativeTo(this);
        JLabel nowLabel = new JLabel("Present index: " + this.selectedIndex);
        JLabel label = new JLabel("Index to go:");
        final JFormattedTextField field = new JFormattedTextField(NumberFormat.getIntegerInstance());
        field.setPreferredSize(new Dimension(100, 20));
        field.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int index = Integer.parseInt(field.getText(), 10);
                if (index >= 0 && index <= HexEditor.this.model.size() - 1) {
                    HexEditor.this.selectionChanged(new SelectEvent(index, "in"));
                    dialog.dispose();
                }
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(nowLabel);
        JPanel inputPanel = new JPanel(new FlowLayout(0));
        inputPanel.add(label);
        inputPanel.add(field);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(panel);
        contentPanel.add(inputPanel);
        dialog.getContentPane().add(contentPanel);
        dialog.pack();
        return dialog;
    }
}

