/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.pagepane;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.fontbox.util.BoundingBox;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDPage;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.dromara.pdf.shade.org.apache.pdfbox.text.PDFTextStripper;
import org.dromara.pdf.shade.org.apache.pdfbox.text.TextPosition;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Vector;

final class DebugTextOverlay {
    private static final Log LOG = LogFactory.getLog(DebugTextOverlay.class);
    private final PDDocument document;
    private final int pageIndex;
    private final float scale;
    private final boolean showTextStripper;
    private final boolean showTextStripperBeads;
    private final boolean showFontBBox;
    private final boolean showGlyphBounds;

    DebugTextOverlay(PDDocument document, int pageIndex, float scale, boolean showTextStripper, boolean showTextStripperBeads, boolean showFontBBox, boolean showGlyphBounds) {
        this.document = document;
        this.pageIndex = pageIndex;
        this.scale = scale;
        this.showTextStripper = showTextStripper;
        this.showTextStripperBeads = showTextStripperBeads;
        this.showFontBBox = showFontBBox;
        this.showGlyphBounds = showGlyphBounds;
    }

    public void renderTo(Graphics2D graphics) throws IOException {
        DebugTextStripper stripper = new DebugTextStripper(graphics);
        stripper.stripPage(this.document, this.document.getPage(this.pageIndex), this.pageIndex, this.scale);
    }

    private class DebugTextStripper
    extends PDFTextStripper {
        private final Graphics2D graphics;
        private AffineTransform flipAT;
        private AffineTransform transAT;

        DebugTextStripper(Graphics2D graphics) {
            this.graphics = graphics;
        }

        public void stripPage(PDDocument document, PDPage page, int pageIndex, float scale) throws IOException {
            PDRectangle cropBox = page.getCropBox();
            this.flipAT = new AffineTransform();
            this.flipAT.translate(0.0, cropBox.getHeight());
            this.flipAT.scale(1.0, -1.0);
            this.transAT = AffineTransform.getTranslateInstance(-cropBox.getLowerLeftX(), cropBox.getLowerLeftY());
            this.transform(this.graphics, page, scale);
            this.graphics.setStroke(new BasicStroke(0.5f));
            this.setStartPage(pageIndex + 1);
            this.setEndPage(pageIndex + 1);
            OutputStreamWriter dummy = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), StandardCharsets.US_ASCII);
            this.writeText(document, dummy);
            if (DebugTextOverlay.this.showTextStripperBeads) {
                List<PDThreadBead> pageArticles = page.getThreadBeads();
                for (PDThreadBead bead : pageArticles) {
                    if (bead == null || bead.getRectangle() == null) continue;
                    PDRectangle r = bead.getRectangle();
                    Shape s = r.toGeneralPath().createTransformedShape(this.transAT);
                    s = this.flipAT.createTransformedShape(s);
                    this.graphics.setColor(Color.green);
                    this.graphics.draw(s);
                }
            }
        }

        private void transform(Graphics2D graphics, PDPage page, float scale) {
            graphics.scale(scale, scale);
            int rotationAngle = page.getRotation();
            PDRectangle cropBox = page.getCropBox();
            if (rotationAngle != 0) {
                float translateX = 0.0f;
                float translateY = 0.0f;
                switch (rotationAngle) {
                    case 90: {
                        translateX = cropBox.getHeight();
                        break;
                    }
                    case 270: {
                        translateY = cropBox.getWidth();
                        break;
                    }
                    case 180: {
                        translateX = cropBox.getWidth();
                        translateY = cropBox.getHeight();
                        break;
                    }
                }
                graphics.translate(translateX, translateY);
                graphics.rotate((float)Math.toRadians(rotationAngle));
            }
        }

        @Override
        protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
            for (TextPosition text : textPositions) {
                if (DebugTextOverlay.this.showTextStripper) {
                    AffineTransform at = (AffineTransform)this.flipAT.clone();
                    at.concatenate(text.getTextMatrix().createAffineTransform());
                    Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, text.getWidthDirAdj() / text.getTextMatrix().getScalingFactorX(), text.getHeightDir() / text.getTextMatrix().getScalingFactorY());
                    this.graphics.setColor(Color.red);
                    this.graphics.draw(at.createTransformedShape(rect));
                }
                if (!DebugTextOverlay.this.showFontBBox) continue;
                PDFont font = text.getFont();
                BoundingBox bbox = font.getBoundingBox();
                float xadvance = font.getWidth(text.getCharacterCodes()[0]);
                Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, bbox.getLowerLeftY(), xadvance, bbox.getHeight());
                AffineTransform at = (AffineTransform)this.flipAT.clone();
                at.concatenate(text.getTextMatrix().createAffineTransform());
                if (font instanceof PDType3Font) {
                    at.concatenate(font.getFontMatrix().createAffineTransform());
                } else {
                    at.scale(0.001f, 0.001f);
                }
                this.graphics.setColor(Color.blue);
                this.graphics.draw(at.createTransformedShape(rect));
            }
        }

        @Override
        protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
            super.showGlyph(textRenderingMatrix, font, code, displacement);
            if (!DebugTextOverlay.this.showGlyphBounds) {
                return;
            }
            AffineTransform at = textRenderingMatrix.createAffineTransform();
            Shape bbox = null;
            try {
                bbox = this.calculateGlyphBounds(at, font, code, displacement);
            }
            catch (IOException ex) {
                LOG.error((Object)("Couldn't get bounds for code " + code + " at position (" + at.getTranslateX() + "," + at.getTranslateY() + ")"), (Throwable)ex);
            }
            if (bbox == null) {
                return;
            }
            Shape transformedBBox = this.flipAT.createTransformedShape(bbox);
            transformedBBox = this.transAT.createTransformedShape(transformedBBox);
            Color color = this.graphics.getColor();
            Stroke stroke = this.graphics.getStroke();
            this.graphics.setColor(Color.cyan);
            this.graphics.setStroke(new BasicStroke(0.5f));
            this.graphics.draw(transformedBBox);
            this.graphics.setStroke(stroke);
            this.graphics.setColor(color);
        }

        private Shape calculateGlyphBounds(AffineTransform at, PDFont font, int code, Vector displacement) throws IOException {
            GeneralPath path;
            at.concatenate(font.getFontMatrix().createAffineTransform());
            if (font instanceof PDType3Font) {
                PDType3Font t3Font = (PDType3Font)font;
                PDType3CharProc charProc = t3Font.getCharProc(code);
                if (charProc == null) {
                    return null;
                }
                BoundingBox fontBBox = t3Font.getBoundingBox();
                PDRectangle glyphBBox = charProc.getGlyphBBox();
                if (glyphBBox == null) {
                    return null;
                }
                glyphBBox.setLowerLeftX(Math.max(fontBBox.getLowerLeftX(), glyphBBox.getLowerLeftX()));
                glyphBBox.setLowerLeftY(Math.max(fontBBox.getLowerLeftY(), glyphBBox.getLowerLeftY()));
                glyphBBox.setUpperRightX(Math.min(fontBBox.getUpperRightX(), glyphBBox.getUpperRightX()));
                glyphBBox.setUpperRightY(Math.min(fontBBox.getUpperRightY(), glyphBBox.getUpperRightY()));
                path = glyphBBox.toGeneralPath();
            } else {
                float fontWidth;
                PDVectorFont vectorFont = (PDVectorFont)((Object)font);
                path = vectorFont.getNormalizedPath(code);
                if (path == null) {
                    return null;
                }
                if (!font.isEmbedded() && !font.isVertical() && !font.isStandard14() && font.hasExplicitWidth(code) && (fontWidth = font.getWidthFromFont(code)) > 0.0f && (double)Math.abs(fontWidth - displacement.getX() * 1000.0f) > 1.0E-4) {
                    float pdfWidth = displacement.getX() * 1000.0f;
                    at.scale(pdfWidth / fontWidth, 1.0);
                }
            }
            return at.createTransformedShape(path.getBounds2D());
        }
    }
}

