/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.signaturepane;

import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSString;

public class SignaturePane {
    private static final String TEXT_TAB = "ASN.1 View";
    private static final int FONT_SIZE = ((Font)UIManager.get("Label.font")).getSize();
    private static final Font FONT_MONOSPACED = new Font("monospaced", 0, FONT_SIZE);
    private final JTabbedPane tabbedPane = new JTabbedPane();

    public SignaturePane(COSString cosString) {
        this.tabbedPane.setPreferredSize(new Dimension(300, 500));
        this.tabbedPane.addTab(TEXT_TAB, new JScrollPane(this.createTextView(cosString)));
    }

    private JTextPane createTextView(COSString cosString) {
        JTextPane textPane = new JTextPane();
        textPane.setText(this.getTextString(cosString));
        textPane.setEditable(false);
        textPane.setFont(FONT_MONOSPACED);
        textPane.setCaretPosition(0);
        return textPane;
    }

    private String getTextString(COSString cosString) {
        String text;
        ASN1StreamParser parser = new ASN1StreamParser(cosString.getBytes());
        try {
            ASN1Encodable encodable = parser.readObject();
            text = ASN1Dump.dumpAsString((Object)encodable, (boolean)true);
        }
        catch (IOException e) {
            text = "<" + cosString.toHexString() + ">";
        }
        return text;
    }

    public JTabbedPane getPane() {
        return this.tabbedPane;
    }
}

