/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.Operator;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBoolean;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSFloat;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNull;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNumber;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSString;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.hexviewer.HexView;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.Stream;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.StreamPaneView;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.ToolTipController;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDResources;
import org.dromara.pdf.shade.org.apache.pdfbox.util.XMLUtil;
import org.w3c.dom.Document;

public class StreamPane
implements ActionListener {
    private static final Log LOG = LogFactory.getLog(StreamPane.class);
    private static final StyleContext CONTEXT = StyleContext.getDefaultStyleContext();
    private static final Style OPERATOR_STYLE = CONTEXT.addStyle("operator", null);
    private static final Style NUMBER_STYLE = CONTEXT.addStyle("number", null);
    private static final Style STRING_STYLE = CONTEXT.addStyle("string", null);
    private static final Style ESCAPE_STYLE = CONTEXT.addStyle("escape", null);
    private static final Style NAME_STYLE = CONTEXT.addStyle("name", null);
    private static final Style INLINE_IMAGE_STYLE = CONTEXT.addStyle("inline_image", null);
    private final JPanel panel;
    private final HexView hexView;
    private final JTabbedPane tabbedPane;
    private final StreamPaneView rawView;
    private final StreamPaneView niceView;
    private final Stream stream;
    private ToolTipController tTController;
    private PDResources resources;

    public StreamPane(COSStream cosStream, boolean isContentStream, boolean isThumb, COSDictionary resourcesDic) throws IOException {
        this.stream = new Stream(cosStream, isThumb);
        if (resourcesDic != null) {
            this.resources = new PDResources(resourcesDic);
            this.tTController = new ToolTipController(this.resources);
        }
        this.panel = new JPanel();
        this.panel.setPreferredSize(new Dimension(300, 500));
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.rawView = new StreamPaneView();
        this.hexView = new HexView();
        this.niceView = isContentStream || this.stream.isXmlMetadata() ? new StreamPaneView() : null;
        if (this.stream.isImage()) {
            this.panel.add(this.createHeaderPanel(this.stream.getFilterList(), "Image", this));
            this.requestImageShowing();
        } else {
            this.panel.add(this.createHeaderPanel(this.stream.getFilterList(), "Decoded (Plain Text)", this));
            this.requestStreamText("Decoded (Plain Text)");
        }
        this.tabbedPane = new JTabbedPane();
        if (this.stream.isImage()) {
            this.tabbedPane.add("Image view", this.rawView.getStreamPanel());
        } else if (this.niceView != null) {
            this.tabbedPane.add("Nice view", this.niceView.getStreamPanel());
            this.tabbedPane.add("Raw view", this.rawView.getStreamPanel());
            this.tabbedPane.add("Hex view", this.hexView.getPane());
        } else {
            this.tabbedPane.add("Text view", this.rawView.getStreamPanel());
            this.tabbedPane.add("Hex view", this.hexView.getPane());
        }
        this.panel.add(this.tabbedPane);
    }

    public JComponent getPanel() {
        return this.panel;
    }

    private JPanel createHeaderPanel(List<String> availableFilters, String i, ActionListener actionListener) {
        JComboBox<String> filters = new JComboBox<String>(availableFilters.toArray(new String[0]));
        filters.setSelectedItem(i);
        filters.addActionListener(actionListener);
        JPanel headerPanel = new JPanel(new FlowLayout());
        headerPanel.add(filters);
        return headerPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            String currentFilter = (String)comboBox.getSelectedItem();
            try {
                if (currentFilter.equals("Image")) {
                    this.requestImageShowing();
                    this.tabbedPane.removeAll();
                    this.tabbedPane.add("Image view", this.rawView.getStreamPanel());
                    return;
                }
                this.tabbedPane.removeAll();
                if ("Decoded (Plain Text)".equals(currentFilter) && this.niceView != null) {
                    this.tabbedPane.add("Nice view", this.niceView.getStreamPanel());
                    this.tabbedPane.add("Raw view", this.rawView.getStreamPanel());
                    this.tabbedPane.add("Hex view", this.hexView.getPane());
                } else {
                    this.tabbedPane.add("Text view", this.rawView.getStreamPanel());
                    this.tabbedPane.add("Hex view", this.hexView.getPane());
                }
                this.requestStreamText(currentFilter);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestImageShowing() {
        if (this.stream.isImage()) {
            BufferedImage image;
            Stream stream = this.stream;
            synchronized (stream) {
                image = this.stream.getImage(this.resources);
            }
            if (image == null) {
                JOptionPane.showMessageDialog(this.panel, "image not available (filter missing?)");
                return;
            }
            this.rawView.showStreamImage(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestStreamText(String command) throws IOException {
        new DocumentCreator(this.rawView, command, false).execute();
        if (this.niceView != null) {
            new DocumentCreator(this.niceView, command, true).execute();
        }
        Stream stream = this.stream;
        synchronized (stream) {
            InputStream is = this.stream.getStream(command);
            if (is == null) {
                JOptionPane.showMessageDialog(this.panel, command + " text not available (filter missing?)");
                return;
            }
            this.hexView.changeData(IOUtils.toByteArray(is));
        }
    }

    static {
        StyleConstants.setForeground(OPERATOR_STYLE, new Color(25, 55, 156));
        StyleConstants.setForeground(NUMBER_STYLE, new Color(51, 86, 18));
        StyleConstants.setForeground(STRING_STYLE, new Color(128, 35, 32));
        StyleConstants.setForeground(ESCAPE_STYLE, new Color(179, 49, 36));
        StyleConstants.setForeground(NAME_STYLE, new Color(140, 38, 145));
        StyleConstants.setForeground(INLINE_IMAGE_STYLE, new Color(116, 113, 39));
    }

    private final class DocumentCreator
    extends SwingWorker<StyledDocument, Integer> {
        private final StreamPaneView targetView;
        private final String filterKey;
        private final boolean nice;
        private int indent;
        private boolean needIndent;

        private DocumentCreator(StreamPaneView targetView, String filterKey, boolean nice) {
            this.targetView = targetView;
            this.filterKey = filterKey;
            this.nice = nice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected StyledDocument doInBackground() {
            String encoding = "ISO-8859-1";
            Stream stream = StreamPane.this.stream;
            synchronized (stream) {
                if (StreamPane.this.stream.isXmlMetadata()) {
                    encoding = "UTF-8";
                }
                InputStream inputStream = StreamPane.this.stream.getStream(this.filterKey);
                if (this.nice && "Decoded (Plain Text)".equals(this.filterKey)) {
                    if (StreamPane.this.stream.isXmlMetadata()) {
                        return this.getXMLDocument(inputStream);
                    }
                    StyledDocument document = this.getContentStreamDocument(inputStream);
                    if (document != null) {
                        return document;
                    }
                    return this.getDocument(inputStream, encoding);
                }
                return this.getDocument(inputStream, encoding);
            }
        }

        @Override
        protected void done() {
            try {
                this.targetView.showStreamText((StyledDocument)this.get(), StreamPane.this.tTController);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private String getStringOfStream(InputStream in, String encoding) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copy(in, baos);
                return baos.toString(encoding);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        private StyledDocument getDocument(InputStream inputStream, String encoding) {
            DefaultStyledDocument docu = new DefaultStyledDocument();
            if (inputStream != null) {
                String data = this.getStringOfStream(inputStream, encoding);
                if (data != null) {
                    data = data.replaceAll("\\R", "\n");
                }
                try {
                    docu.insertString(0, data, null);
                }
                catch (BadLocationException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return docu;
        }

        private StyledDocument getXMLDocument(InputStream inputStream) {
            DefaultStyledDocument docu = new DefaultStyledDocument();
            if (inputStream != null) {
                try {
                    Document doc = XMLUtil.parse(inputStream);
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
                    StringWriter sw = new StringWriter();
                    StreamResult result = new StreamResult(sw);
                    DOMSource source = new DOMSource(doc);
                    transformer.transform(source, result);
                    docu.insertString(0, sw.toString(), null);
                }
                catch (IOException | IllegalArgumentException | BadLocationException | TransformerException | TransformerFactoryConfigurationError ex) {
                    LOG.error((Object)ex.getMessage(), ex);
                }
            }
            return docu;
        }

        private StyledDocument getContentStreamDocument(InputStream inputStream) {
            DefaultStyledDocument docu = new DefaultStyledDocument();
            try {
                PDFStreamParser parser = new PDFStreamParser(IOUtils.toByteArray(inputStream));
                parser.parse().forEach(obj -> this.writeToken(obj, docu));
            }
            catch (IOException e) {
                return null;
            }
            return docu;
        }

        private void writeToken(Object obj, StyledDocument docu) {
            try {
                if (obj instanceof Operator) {
                    this.addOperators(obj, docu);
                } else {
                    this.writeOperand(obj, docu);
                }
            }
            catch (BadLocationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private void writeOperand(Object obj, StyledDocument docu) throws BadLocationException {
            this.writeIndent(docu);
            if (obj instanceof COSName) {
                String str = "/" + ((COSName)obj).getName();
                docu.insertString(docu.getLength(), str + " ", NAME_STYLE);
            } else if (obj instanceof COSBoolean) {
                String str = obj.toString();
                docu.insertString(docu.getLength(), str + " ", null);
            } else if (obj instanceof COSArray) {
                docu.insertString(docu.getLength(), "[ ", null);
                for (COSBase elem : (COSArray)obj) {
                    this.writeOperand(elem, docu);
                }
                docu.insertString(docu.getLength(), "] ", null);
            } else if (obj instanceof COSString) {
                byte[] bytes;
                docu.insertString(docu.getLength(), "(", null);
                for (byte b : bytes = ((COSString)obj).getBytes()) {
                    String str;
                    int chr = b & 0xFF;
                    if (chr == 40 || chr == 41 || chr == 92) {
                        str = "\\" + (char)chr;
                        docu.insertString(docu.getLength(), str, ESCAPE_STYLE);
                        continue;
                    }
                    if (chr < 32 || chr > 126) {
                        str = String.format("\\%03o", chr);
                        docu.insertString(docu.getLength(), str, ESCAPE_STYLE);
                        continue;
                    }
                    str = Character.toString((char)chr);
                    docu.insertString(docu.getLength(), str, STRING_STYLE);
                }
                docu.insertString(docu.getLength(), ") ", null);
            } else if (obj instanceof COSNumber) {
                String str = obj instanceof COSFloat ? Float.toString(((COSFloat)obj).floatValue()) : Integer.toString(((COSNumber)obj).intValue());
                docu.insertString(docu.getLength(), str + " ", NUMBER_STYLE);
            } else if (obj instanceof COSDictionary) {
                docu.insertString(docu.getLength(), "<< ", null);
                COSDictionary dict = (COSDictionary)obj;
                for (Map.Entry<COSName, COSBase> entry : dict.entrySet()) {
                    this.writeOperand(entry.getKey(), docu);
                    this.writeOperand(entry.getValue(), docu);
                }
                docu.insertString(docu.getLength(), ">> ", null);
            } else if (obj instanceof COSNull) {
                docu.insertString(docu.getLength(), "null ", null);
            } else {
                String str = obj.toString();
                str = str.substring(str.indexOf(123) + 1, str.length() - 1);
                docu.insertString(docu.getLength(), str + " ", null);
            }
        }

        private void addOperators(Object obj, StyledDocument docu) throws BadLocationException {
            Operator op = (Operator)obj;
            if (op.getName().equals("ET") || op.getName().equals("Q") || op.getName().equals("EMC")) {
                --this.indent;
            }
            this.writeIndent(docu);
            if (op.getName().equals("BI")) {
                docu.insertString(docu.getLength(), "BI\n", OPERATOR_STYLE);
                COSDictionary dic = op.getImageParameters();
                for (COSName key : dic.keySet()) {
                    COSBase value = dic.getDictionaryObject(key);
                    docu.insertString(docu.getLength(), "/" + key.getName() + " ", null);
                    this.writeToken(value, docu);
                    docu.insertString(docu.getLength(), "\n", null);
                }
                String imageString = new String(op.getImageData(), StandardCharsets.ISO_8859_1);
                docu.insertString(docu.getLength(), "ID\n", INLINE_IMAGE_STYLE);
                docu.insertString(docu.getLength(), imageString, null);
                docu.insertString(docu.getLength(), "\n", null);
                docu.insertString(docu.getLength(), "EI\n", OPERATOR_STYLE);
            } else {
                String operator = ((Operator)obj).getName();
                docu.insertString(docu.getLength(), operator + "\n", OPERATOR_STYLE);
                if (op.getName().equals("BT") || op.getName().equals("q") || op.getName().equals("BMC") || op.getName().equals("BDC")) {
                    ++this.indent;
                }
            }
            this.needIndent = true;
        }

        void writeIndent(StyledDocument docu) throws BadLocationException {
            if (this.needIndent) {
                for (int i = 0; i < this.indent; ++i) {
                    docu.insertString(docu.getLength(), "  ", null);
                }
                this.needIndent = false;
            }
        }
    }
}

