/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip;

import java.awt.Color;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.ColorToolTip;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDResources;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDPattern;

final class SCNToolTip
extends ColorToolTip {
    private static final Log LOG = LogFactory.getLog(SCNToolTip.class);

    SCNToolTip(PDResources resources, String colorSpaceName, String rowText) {
        this.createMarkUp(resources, colorSpaceName.substring(1).trim(), rowText);
    }

    private void createMarkUp(PDResources resources, String colorSpaceName, String rowText) {
        PDColorSpace colorSpace = null;
        try {
            colorSpace = resources.getColorSpace(COSName.getPDFName(colorSpaceName));
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (colorSpace instanceof PDPattern) {
            this.setToolTipText("<html>Pattern</html>");
            return;
        }
        if (colorSpace != null) {
            try {
                float[] rgbValues = colorSpace.toRGB(this.extractColorValues(rowText));
                if (rgbValues != null) {
                    Color color = new Color(rgbValues[0], rgbValues[1], rgbValues[2]);
                    this.setToolTipText(this.getMarkUp(SCNToolTip.colorHexValue(color)));
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

