/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.FontToolTip;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.GToolTip;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.KToolTip;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.RGToolTip;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.streampane.tooltip.SCNToolTip;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDResources;

public class ToolTipController {
    private static final Log LOG = LogFactory.getLog(ToolTipController.class);
    private final PDResources resources;
    private JTextComponent textComponent;

    public ToolTipController(PDResources resources) {
        this.resources = resources;
    }

    static List<String> getWords(String str) {
        ArrayList<String> words = new ArrayList<String>();
        for (String string : str.trim().split(" ")) {
            if ((string = string.trim()).isEmpty() || string.equals("\n")) continue;
            words.add(string);
        }
        return words;
    }

    public String getToolTip(int offset, JTextComponent textComponent) {
        this.textComponent = textComponent;
        String word = this.getWord(offset);
        if (word == null) {
            return null;
        }
        String rowText = this.getRowText(offset);
        switch (word) {
            case "Tf": {
                FontToolTip toolTip = new FontToolTip(this.resources, rowText);
                return toolTip.getToolTipText();
            }
            case "SCN": {
                String colorSpaceName = this.findColorSpace(offset, "CS");
                if (colorSpaceName == null) break;
                SCNToolTip toolTip = new SCNToolTip(this.resources, colorSpaceName, rowText);
                return toolTip.getToolTipText();
            }
            case "scn": {
                String colorSpaceName = this.findColorSpace(offset, "cs");
                if (colorSpaceName == null) break;
                SCNToolTip toolTip = new SCNToolTip(this.resources, colorSpaceName, rowText);
                return toolTip.getToolTipText();
            }
            case "RG": 
            case "rg": {
                RGToolTip toolTip = new RGToolTip(rowText);
                return toolTip.getToolTipText();
            }
            case "K": 
            case "k": {
                KToolTip toolTip = new KToolTip(rowText);
                return toolTip.getToolTipText();
            }
            case "G": 
            case "g": {
                GToolTip toolTip = new GToolTip(rowText);
                return toolTip.getToolTipText();
            }
        }
        return null;
    }

    private String findColorSpace(int offset, String colorSpaceType) {
        try {
            while (offset != -1) {
                String previousRowText = this.getRowText(offset = Utilities.getPositionAbove(this.textComponent, offset, 0));
                if (previousRowText == null) {
                    return null;
                }
                if (!this.isColorSpace(colorSpaceType, previousRowText = previousRowText.trim())) continue;
                return previousRowText.split(" ")[0];
            }
        }
        catch (BadLocationException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return null;
    }

    private boolean isColorSpace(String colorSpaceType, String rowText) {
        List<String> words = ToolTipController.getWords(rowText);
        return words.size() == 2 && words.get(1).equals(colorSpaceType);
    }

    private String getWord(int offset) {
        try {
            int start = Utilities.getWordStart(this.textComponent, offset);
            int end = Utilities.getWordEnd(this.textComponent, offset);
            return this.textComponent.getDocument().getText(start, end - start + 1).trim();
        }
        catch (BadLocationException e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private String getRowText(int offset) {
        try {
            int rowStart = Utilities.getRowStart(this.textComponent, offset);
            int rowEnd = Utilities.getRowEnd(this.textComponent, offset);
            return this.textComponent.getDocument().getText(rowStart, rowEnd - rowStart + 1);
        }
        catch (BadLocationException e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

