/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;

public class ErrorDialog
extends JDialog {
    private static final List<String> FILTERS = Arrays.asList("java.awt.", "javax.swing.", "sun.reflect.", "java.util.concurrent.");
    private static final Dimension MESSAGE_SIZE = new Dimension(800, 200);
    private static final Dimension STACKTRACE_SIZE = new Dimension(800, 300);
    private static final Dimension TOTAL_SIZE = new Dimension(800, 500);
    private static final int BORDER_SIZE = 20;
    private static final String NEWLINE = "\r\n";
    private static final String INDENT = "    ";
    private boolean showingDetails;
    private boolean isFiltering = true;
    private final JComponent message;
    private final JComponent main;
    private JScrollPane details;
    private JTextPane stacktrace;
    private final Throwable error;

    public ErrorDialog(Throwable t) {
        this(null, null, t);
    }

    public ErrorDialog(JComponent owner, Throwable t) {
        this(owner, null, t);
    }

    public ErrorDialog(JComponent owner, Icon icon, Throwable t) {
        this.setTitle(t.getClass().getName());
        this.setModal(true);
        if (icon instanceof ImageIcon) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
        this.setDefaultCloseOperation(2);
        this.error = t;
        this.message = this.createErrorMessage(this.error);
        this.main = this.createContent();
        this.getContentPane().add(this.main);
        this.pack();
        ErrorDialog.position(this, owner);
    }

    static void position(Component c, Component parent) {
        Dimension d = c.getPreferredSize();
        if (parent == null) {
            Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
            c.setLocation(s.width / 2 - d.width / 2, s.height / 2 - d.height / 2);
        } else {
            Point p = parent.getLocationOnScreen();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            c.setLocation(p.x + pw / 2 - d.width / 2, p.y + ph / 2 - d.height / 2);
        }
    }

    final JComponent createContent() {
        JButton showDetails = new JButton("Show Details >>");
        showDetails.addActionListener(e -> {
            if (this.showingDetails) {
                this.main.remove(this.details);
                this.main.validate();
                this.main.setPreferredSize(MESSAGE_SIZE);
            } else {
                if (this.details == null) {
                    this.details = this.createDetailedMessage();
                    StringBuilder buffer = new StringBuilder();
                    this.stacktrace.setText(this.generateStackTrace(this.error, buffer).toString());
                    this.stacktrace.setCaretPosition(0);
                    this.stacktrace.setBackground(this.main.getBackground());
                    this.stacktrace.setPreferredSize(STACKTRACE_SIZE);
                }
                this.main.add((Component)this.details, "Center");
                this.main.validate();
                this.main.setPreferredSize(TOTAL_SIZE);
            }
            this.showingDetails = !this.showingDetails;
            showDetails.setText(this.showingDetails ? "<< Hide Details" : "Show Details >>");
            this.pack();
        });
        JPanel messagePanel = new JPanel();
        JCheckBox filter = new JCheckBox("Filter stack traces");
        filter.setSelected(this.isFiltering);
        filter.addActionListener(e -> {
            this.isFiltering = filter.isSelected();
            StringBuilder buffer = new StringBuilder();
            this.stacktrace.setText(this.generateStackTrace(this.error, buffer).toString());
            this.stacktrace.setCaretPosition(0);
            this.stacktrace.repaint();
        });
        this.message.setBackground(messagePanel.getBackground());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(showDetails);
        buttonPanel.add(filter);
        buttonPanel.add(Box.createHorizontalGlue());
        messagePanel.setLayout(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        messagePanel.add((Component)this.message, "Center");
        messagePanel.add((Component)buttonPanel, "South");
        messagePanel.setPreferredSize(MESSAGE_SIZE);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)messagePanel, "North");
        ActionListener actionListener = actionEvent -> this.dispose();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        panel.registerKeyboardAction(actionListener, stroke, 2);
        return panel;
    }

    final JComponent createErrorMessage(Throwable t) {
        String txt = t.getLocalizedMessage();
        JEditorPane msg = new JEditorPane();
        msg.setContentType("text/plain");
        msg.setEditable(false);
        msg.setText(txt);
        return msg;
    }

    JScrollPane createDetailedMessage() {
        this.stacktrace = new JTextPane();
        this.stacktrace.setEditable(false);
        return new JScrollPane(this.stacktrace, 20, 30);
    }

    StringBuilder generateStackTrace(Throwable t, StringBuilder buffer) {
        buffer.append(t.getClass().getName()).append(": ").append(t.getMessage()).append(NEWLINE);
        buffer.append((CharSequence)this.toString(t.getStackTrace()));
        Throwable cause = t.getCause();
        if (cause != null && !cause.equals(t)) {
            buffer.append("Caused by: ");
            this.generateStackTrace(cause, buffer);
        }
        return buffer;
    }

    StringBuilder toString(StackTraceElement[] traces) {
        StringBuilder err = new StringBuilder();
        for (StackTraceElement e : traces) {
            if (this.isFiltering && this.isSuppressed(e.getClassName())) continue;
            String str = e.toString();
            err.append(INDENT).append(str).append(NEWLINE);
        }
        return err;
    }

    private boolean isSuppressed(String className) {
        return FILTERS.stream().anyMatch(className::startsWith);
    }
}

