/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;

public class FileOpenSaveDialog {
    private final Component mainUI;
    private static final JFileChooser FILE_CHOOSER = new JFileChooser(){

        @Override
        public void approveSelection() {
            int result;
            File selectedFile = this.getSelectedFile();
            if (selectedFile.exists() && this.getDialogType() == 1 && (result = JOptionPane.showConfirmDialog(this, "Do you want to overwrite?", "File already exists", 0)) != 0) {
                this.cancelSelection();
                return;
            }
            super.approveSelection();
        }
    };

    public FileOpenSaveDialog(Component parentUI, FileFilter fileFilter) {
        this.mainUI = parentUI;
        FILE_CHOOSER.resetChoosableFileFilters();
        FILE_CHOOSER.setFileFilter(fileFilter);
    }

    public boolean saveFile(byte[] bytes, String extension) throws IOException {
        int result = FILE_CHOOSER.showSaveDialog(this.mainUI);
        if (result == 0) {
            String filename = FILE_CHOOSER.getSelectedFile().getAbsolutePath();
            if (extension != null && !filename.endsWith(extension)) {
                filename = filename + "." + extension;
            }
            Files.write(Paths.get(filename, new String[0]), bytes, new OpenOption[0]);
            return true;
        }
        return false;
    }

    public boolean saveDocument(PDDocument document, String extension) throws IOException {
        int result = FILE_CHOOSER.showSaveDialog(this.mainUI);
        if (result == 0) {
            String filename = FILE_CHOOSER.getSelectedFile().getAbsolutePath();
            if (!filename.endsWith(extension)) {
                filename = filename + "." + extension;
            }
            document.setAllSecurityToBeRemoved(true);
            document.save(filename);
            return true;
        }
        return false;
    }

    public File openFile() throws IOException {
        int result = FILE_CHOOSER.showOpenDialog(this.mainUI);
        if (result == 0) {
            return FILE_CHOOSER.getSelectedFile();
        }
        return null;
    }
}

