/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;

public class PageEntry {
    private final COSDictionary dict;
    private final int pageNum;
    private final String pageLabel;

    public PageEntry(COSDictionary page, int pageNum, String pageLabel) {
        this.dict = page;
        this.pageNum = pageNum;
        this.pageLabel = pageLabel;
    }

    public COSDictionary getDict() {
        return this.dict;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public String toString() {
        return "Page: " + this.pageNum + (this.pageLabel == null ? "" : " - " + this.pageLabel);
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("Root/Pages");
        COSDictionary node = this.dict;
        while (node.containsKey(COSName.PARENT)) {
            COSDictionary parent = node.getCOSDictionary(COSName.PARENT);
            if (parent == null) {
                return "";
            }
            COSArray kids = parent.getCOSArray(COSName.KIDS);
            if (kids == null) {
                return "";
            }
            int idx = kids.indexOfObject(node);
            if (idx == -1) break;
            sb.append("/Kids/[").append(idx).append("]");
            node = parent;
        }
        return sb.toString();
    }
}

