/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.MenuBase;

public final class PrintDpiMenu
extends MenuBase {
    private static final int[] DPIS = new int[]{0, 100, 200, 300, 600, 1200, -1};
    private static PrintDpiMenu instance;
    private final JMenu menu = new JMenu("Print rastering");

    private PrintDpiMenu() {
        ButtonGroup bg = new ButtonGroup();
        for (int dpi : DPIS) {
            String text;
            switch (dpi) {
                case 0: {
                    text = "off";
                    break;
                }
                case -1: {
                    text = "printer dpi";
                    break;
                }
                default: {
                    text = dpi + " dpi";
                }
            }
            PrintDpiMenuItem printDpiMenuItem = new PrintDpiMenuItem(text, dpi);
            bg.add(printDpiMenuItem);
            this.menu.add(printDpiMenuItem);
        }
        this.changeDpiSelection(0);
        this.setMenu(this.menu);
    }

    public static PrintDpiMenu getInstance() {
        if (instance == null) {
            instance = new PrintDpiMenu();
        }
        return instance;
    }

    public void changeDpiSelection(int selection) {
        for (Component comp : this.menu.getMenuComponents()) {
            PrintDpiMenuItem menuItem = (PrintDpiMenuItem)comp;
            if (menuItem.dpi != selection) continue;
            menuItem.setSelected(true);
            return;
        }
        throw new IllegalArgumentException("no dpi menu item found for: " + selection);
    }

    public static int getDpiSelection() {
        for (Component comp : PrintDpiMenu.instance.menu.getMenuComponents()) {
            PrintDpiMenuItem menuItem = (PrintDpiMenuItem)comp;
            if (!menuItem.isSelected()) continue;
            return menuItem.dpi;
        }
        throw new IllegalStateException("no dpi menu item is selected");
    }

    private static class PrintDpiMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = -475209538362541000L;
        private final int dpi;

        PrintDpiMenuItem(String text, int dpi) {
            super(text);
            this.dpi = dpi;
        }
    }
}

