/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;

public class RecentFiles {
    private static final String KEY = "recent_files_";
    private static final String PATH_KEY = "recent_files_%d_%d";
    private static final String PIECES_LENGTH_KEY = "recent_files_%d_length";
    private static final String HISTORY_LENGTH = "history_length";
    private final Preferences pref;
    private Queue<String> filePaths;
    private final int maximum;

    public RecentFiles(Class<?> className, int maximumFile) {
        this.maximum = maximumFile;
        this.pref = Preferences.userNodeForPackage(className);
        this.filePaths = this.readHistoryFromPref();
        if (this.filePaths == null) {
            this.filePaths = new ArrayDeque<String>();
        }
    }

    public void removeAll() {
        this.filePaths.clear();
    }

    public boolean isEmpty() {
        return this.filePaths.isEmpty();
    }

    public void addFile(String path) {
        if (this.filePaths.size() >= this.maximum + 1 && path != null) {
            this.filePaths.remove();
        }
        this.filePaths.add(path);
    }

    public void removeFile(String path) {
        this.filePaths.remove(path);
    }

    public List<String> getFiles() {
        if (!this.isEmpty()) {
            List<String> files = this.filePaths.stream().filter(path -> new File((String)path).exists()).collect(Collectors.toList());
            if (files.size() > this.maximum) {
                files.remove(0);
            }
            return files;
        }
        return null;
    }

    public void close() throws IOException {
        this.writeHistoryToPref(this.filePaths);
    }

    private String[] breakString(String fullPath) {
        int allowedStringLength = 8192;
        ArrayList<String> pieces = new ArrayList<String>();
        int beginIndex = 0;
        int remainingLength = fullPath.length();
        int endIndex = 0;
        while (remainingLength > 0) {
            pieces.add(fullPath.substring(beginIndex, endIndex += Math.min(remainingLength, allowedStringLength)));
            beginIndex = endIndex;
            remainingLength = fullPath.length() - endIndex;
        }
        return pieces.toArray(new String[pieces.size()]);
    }

    private void writeHistoryToPref(Queue<String> filePaths) {
        if (filePaths.isEmpty()) {
            return;
        }
        Preferences node = this.pref.node(KEY);
        node.putInt(HISTORY_LENGTH, filePaths.size());
        int fileCount = 1;
        for (String path : filePaths) {
            String[] pieces = this.breakString(path);
            node.putInt(String.format(PIECES_LENGTH_KEY, fileCount), pieces.length);
            for (int i = 0; i < pieces.length; ++i) {
                node.put(String.format(PATH_KEY, fileCount, i), pieces[i]);
            }
            ++fileCount;
        }
    }

    private Queue<String> readHistoryFromPref() {
        Preferences node = this.pref.node(KEY);
        int historyLength = node.getInt(HISTORY_LENGTH, 0);
        if (historyLength == 0) {
            return null;
        }
        ArrayDeque<String> history = new ArrayDeque<String>();
        for (int i = 1; i <= historyLength; ++i) {
            int totalPieces = node.getInt(String.format(PIECES_LENGTH_KEY, i), 0);
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < totalPieces; ++j) {
                String piece = node.get(String.format(PATH_KEY, i, j), "");
                stringBuilder.append(piece);
            }
            history.add(stringBuilder.toString());
        }
        return history;
    }
}

