/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.MenuBase;
import org.dromara.pdf.shade.org.apache.pdfbox.rendering.RenderDestination;

public final class RenderDestinationMenu
extends MenuBase {
    public static final String RENDER_DESTINATION_EXPORT = "Export";
    public static final String RENDER_DESTINATION_PRINT = "Print";
    public static final String RENDER_DESTINATION_VIEW = "View";
    private static RenderDestinationMenu instance;
    private JRadioButtonMenuItem exportItem;
    private JRadioButtonMenuItem printItem;
    private JRadioButtonMenuItem viewItem;

    private RenderDestinationMenu() {
        this.setMenu(this.createMenu());
    }

    public static RenderDestinationMenu getInstance() {
        if (instance == null) {
            instance = new RenderDestinationMenu();
        }
        return instance;
    }

    public void setRenderDestinationSelection(String selection) {
        switch (selection) {
            case "Export": {
                this.exportItem.setSelected(true);
                break;
            }
            case "Print": {
                this.printItem.setSelected(true);
                break;
            }
            case "View": {
                this.viewItem.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid RenderDestination selection: " + selection);
            }
        }
    }

    public static boolean isRenderDestinationMenu(String actionCommand) {
        return RENDER_DESTINATION_EXPORT.equals(actionCommand) || RENDER_DESTINATION_PRINT.equals(actionCommand) || RENDER_DESTINATION_VIEW.equals(actionCommand);
    }

    public static RenderDestination getRenderDestination() {
        if (RenderDestinationMenu.instance.printItem.isSelected()) {
            return RenderDestination.PRINT;
        }
        if (RenderDestinationMenu.instance.viewItem.isSelected()) {
            return RenderDestination.VIEW;
        }
        return RenderDestination.EXPORT;
    }

    public static RenderDestination getRenderDestination(String actionCommand) {
        switch (actionCommand) {
            case "Export": {
                return RenderDestination.EXPORT;
            }
            case "Print": {
                return RenderDestination.PRINT;
            }
            case "View": {
                return RenderDestination.VIEW;
            }
        }
        throw new IllegalArgumentException("Invalid RenderDestination actionCommand: " + actionCommand);
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu();
        menu.setText("Render destination");
        this.exportItem = new JRadioButtonMenuItem();
        this.printItem = new JRadioButtonMenuItem();
        this.viewItem = new JRadioButtonMenuItem();
        this.exportItem.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.exportItem);
        bg.add(this.printItem);
        bg.add(this.viewItem);
        this.exportItem.setText(RENDER_DESTINATION_EXPORT);
        this.printItem.setText(RENDER_DESTINATION_PRINT);
        this.viewItem.setText(RENDER_DESTINATION_VIEW);
        menu.add(this.exportItem);
        menu.add(this.printItem);
        menu.add(this.viewItem);
        return menu;
    }
}

