/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.MenuBase;

public final class TreeViewMenu
extends MenuBase {
    public static final String VIEW_PAGES = "Show pages";
    public static final String VIEW_STRUCTURE = "Internal structure";
    public static final String VIEW_CROSS_REF_TABLE = "Cross reference table";
    private static final List<String> validTreeModes = Arrays.asList("Show pages", "Internal structure", "Cross reference table");
    private static TreeViewMenu instance;
    private JRadioButtonMenuItem pagesItem;
    private JRadioButtonMenuItem structureItem;
    private JRadioButtonMenuItem crtItem;

    private TreeViewMenu() {
        this.setMenu(this.createTreeViewMenu());
    }

    public static TreeViewMenu getInstance() {
        if (instance == null) {
            instance = new TreeViewMenu();
        }
        return instance;
    }

    public void setTreeViewSelection(String selection) {
        switch (selection) {
            case "Show pages": {
                this.pagesItem.setSelected(true);
                break;
            }
            case "Internal structure": {
                this.structureItem.setSelected(true);
                break;
            }
            case "Cross reference table": {
                this.crtItem.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tree view selection: " + selection);
            }
        }
    }

    public String getTreeViewSelection() {
        if (this.pagesItem.isSelected()) {
            return VIEW_PAGES;
        }
        if (this.structureItem.isSelected()) {
            return VIEW_STRUCTURE;
        }
        if (this.crtItem.isSelected()) {
            return VIEW_CROSS_REF_TABLE;
        }
        throw new IllegalStateException("No tree view selection");
    }

    public static boolean isValidViewMode(String viewMode) {
        return validTreeModes.contains(viewMode);
    }

    private JMenu createTreeViewMenu() {
        JMenu menu = new JMenu();
        menu.setText("Tree view");
        this.pagesItem = new JRadioButtonMenuItem();
        this.structureItem = new JRadioButtonMenuItem();
        this.crtItem = new JRadioButtonMenuItem();
        this.pagesItem.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.pagesItem);
        bg.add(this.structureItem);
        bg.add(this.crtItem);
        this.pagesItem.setText(VIEW_PAGES);
        this.structureItem.setText(VIEW_STRUCTURE);
        this.crtItem.setText(VIEW_CROSS_REF_TABLE);
        menu.add(this.pagesItem);
        menu.add(this.structureItem);
        menu.add(this.crtItem);
        return menu;
    }
}

