/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.MenuBase;

public final class ZoomMenu
extends MenuBase {
    private float pageZoomScale = 1.0f;
    private float imageZoomScale = 1.0f;
    private static final int[] ZOOMS = new int[]{25, 50, 100, 150, 200, 400, 1000, 2000};
    private static ZoomMenu instance;
    private final JMenu menu = new JMenu("Zoom");

    private ZoomMenu() {
        ButtonGroup bg = new ButtonGroup();
        for (int zoom : ZOOMS) {
            ZoomMenuItem zoomItem = new ZoomMenuItem(zoom + "%", zoom);
            bg.add(zoomItem);
            this.menu.add(zoomItem);
        }
        this.setMenu(this.menu);
    }

    public static ZoomMenu getInstance() {
        if (instance == null) {
            instance = new ZoomMenu();
        }
        return instance;
    }

    public void changeZoomSelection(float zoomValue) {
        int selection = (int)(zoomValue * 100.0f);
        for (Component comp : this.menu.getMenuComponents()) {
            ZoomMenuItem menuItem = (ZoomMenuItem)comp;
            if (menuItem.zoom != selection) continue;
            menuItem.setSelected(true);
            return;
        }
        throw new IllegalArgumentException("no zoom menu item found for: " + selection + "%");
    }

    public static boolean isZoomMenu(String actionCommand) {
        if (!actionCommand.matches("^\\d+%$")) {
            return false;
        }
        int zoom = Integer.parseInt(actionCommand.substring(0, actionCommand.length() - 1));
        return Arrays.binarySearch(ZOOMS, zoom) >= 0;
    }

    public static float getZoomScale() {
        for (Component comp : ZoomMenu.instance.menu.getMenuComponents()) {
            ZoomMenuItem menuItem = (ZoomMenuItem)comp;
            if (!menuItem.isSelected()) continue;
            return (float)menuItem.zoom / 100.0f;
        }
        throw new IllegalStateException("no zoom menu item is selected");
    }

    public float getPageZoomScale() {
        return this.pageZoomScale;
    }

    public void setPageZoomScale(float pageZoomValue) {
        this.pageZoomScale = pageZoomValue;
    }

    public float getImageZoomScale() {
        return this.imageZoomScale;
    }

    public void setImageZoomScale(float imageZoomValue) {
        this.imageZoomScale = imageZoomValue;
    }

    public void resetZoom() {
        this.setPageZoomScale(1.0f);
        this.setImageZoomScale(1.0f);
        this.changeZoomSelection(1.0f);
    }

    private static class ZoomMenuItem
    extends JRadioButtonMenuItem {
        private final int zoom;

        ZoomMenuItem(String text, int zoom) {
            super(text);
            this.zoom = zoom;
        }
    }
}

