/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.textsearcher;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.PDFDebugger;

class SearchPanel {
    private final Action nextAction;
    private final Action previousAction;
    private JCheckBox caseSensitive;
    private JTextField searchField;
    private JLabel counterLabel;
    private JPanel panel;
    private final Action closeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchPanel.this.panel.setVisible(false);
            SearchPanel.this.closeAction.setEnabled(false);
            SearchPanel.this.panel.getParent().transferFocus();
        }
    };
    private final Action findAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SearchPanel.this.panel.isVisible()) {
                SearchPanel.this.panel.setVisible(true);
                SearchPanel.this.panel.getParent().validate();
                return;
            }
            SearchPanel.this.reFocus();
        }
    };

    SearchPanel(DocumentListener documentListener, ChangeListener changeListener, ComponentListener compListener, Action nextAction, Action previousAction) {
        this.nextAction = nextAction;
        this.previousAction = previousAction;
        this.initUI(documentListener, changeListener, compListener);
    }

    private void initUI(DocumentListener documentListener, ChangeListener changeListener, ComponentListener compListener) {
        this.searchField = new JTextField();
        this.searchField.getDocument().addDocumentListener(documentListener);
        this.counterLabel = new JLabel();
        this.counterLabel.setVisible(false);
        JButton nextButton = new JButton();
        nextButton.setAction(this.nextAction);
        nextButton.setText("Next");
        JButton previousButton = new JButton();
        previousButton.setAction(this.previousAction);
        previousButton.setText("Previous");
        this.caseSensitive = new JCheckBox("Match case");
        this.caseSensitive.setSelected(false);
        this.caseSensitive.addChangeListener(changeListener);
        this.caseSensitive.setToolTipText("Check for case sensitive search");
        JButton crossButton = new JButton();
        crossButton.setAction(this.closeAction);
        crossButton.setText("Done");
        this.closeAction.setEnabled(false);
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        this.panel.setBackground(new Color(230, 230, 230));
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(Box.createHorizontalGlue());
        this.panel.add(this.searchField);
        this.panel.add(this.counterLabel);
        this.panel.add(previousButton);
        this.panel.add(nextButton);
        this.panel.add(this.caseSensitive);
        this.panel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.panel.add(crossButton);
        this.panel.addComponentListener(compListener);
        this.searchField.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), this.closeAction);
    }

    boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    String getSearchWord() {
        return this.searchField.getText();
    }

    void reset() {
        this.counterLabel.setVisible(false);
    }

    void updateCounterLabel(int now, int total) {
        if (!this.counterLabel.isVisible()) {
            this.counterLabel.setVisible(true);
        }
        if (total == 0) {
            this.counterLabel.setText(" No match found ");
            this.nextAction.setEnabled(false);
            return;
        }
        this.counterLabel.setText(" " + now + " of " + total + " ");
    }

    JPanel getPanel() {
        return this.panel;
    }

    public void reFocus() {
        this.searchField.requestFocus();
        String searchKey = this.searchField.getText();
        this.searchField.setText(searchKey);
        this.searchField.setSelectionStart(0);
        this.searchField.setSelectionEnd(this.searchField.getText().length());
        this.closeAction.setEnabled(true);
    }

    public void addMenuListeners(PDFDebugger frame) {
        frame.getFindMenu().setEnabled(true);
        frame.getFindMenuItem().addActionListener(this.findAction);
        frame.getFindNextMenuItem().addActionListener(this.nextAction);
        frame.getFindPreviousMenuItem().addActionListener(this.previousAction);
    }

    public void removeMenuListeners(PDFDebugger frame) {
        frame.getFindMenu().setEnabled(false);
        frame.getFindMenuItem().removeActionListener(this.findAction);
        frame.getFindNextMenuItem().removeActionListener(this.nextAction);
        frame.getFindPreviousMenuItem().removeActionListener(this.previousAction);
    }
}

