/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.textsearcher;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.PDFDebugger;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.textsearcher.SearchEngine;
import org.dromara.pdf.shade.org.apache.pdfbox.debugger.ui.textsearcher.SearchPanel;

public class Searcher
implements DocumentListener,
ChangeListener,
ComponentListener {
    private static final Log LOG = LogFactory.getLog(Searcher.class);
    private static final Highlighter.HighlightPainter PAINTER = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
    private static final Highlighter.HighlightPainter SELECTION_PAINTER = new DefaultHighlighter.DefaultHighlightPainter(new Color(109, 216, 26));
    private final SearchEngine searchEngine;
    private final SearchPanel searchPanel;
    private final JTextComponent textComponent;
    private int totalMatch = 0;
    private int currentMatch = -1;
    private List<Highlighter.Highlight> highlights;
    private final Action previousAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Searcher.this.totalMatch != 0 && Searcher.this.currentMatch != 0) {
                Searcher.this.currentMatch = Searcher.this.currentMatch - 1;
                int offset = ((Highlighter.Highlight)Searcher.this.highlights.get(Searcher.this.currentMatch)).getStartOffset();
                Searcher.this.scrollToWord(offset);
                Searcher.this.updateHighLighter(Searcher.this.currentMatch, Searcher.this.currentMatch + 1);
                Searcher.this.updateNavigationButtons();
            }
        }
    };
    private final Action nextAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Searcher.this.totalMatch != 0 && Searcher.this.currentMatch != Searcher.this.totalMatch - 1) {
                Searcher.this.currentMatch = Searcher.this.currentMatch + 1;
                int offset = ((Highlighter.Highlight)Searcher.this.highlights.get(Searcher.this.currentMatch)).getStartOffset();
                Searcher.this.scrollToWord(offset);
                Searcher.this.updateHighLighter(Searcher.this.currentMatch, Searcher.this.currentMatch - 1);
                Searcher.this.updateNavigationButtons();
            }
        }
    };

    public Searcher(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.searchPanel = new SearchPanel(this, this, this, this.nextAction, this.previousAction);
        this.searchEngine = new SearchEngine(textComponent, PAINTER);
        this.nextAction.setEnabled(false);
        this.previousAction.setEnabled(false);
    }

    public JPanel getSearchPanel() {
        return this.searchPanel.getPanel();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.search(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.search(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.search(documentEvent);
    }

    private void search(DocumentEvent documentEvent) {
        try {
            String word = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            if (word.isEmpty()) {
                this.nextAction.setEnabled(false);
                this.previousAction.setEnabled(false);
                this.searchPanel.reset();
                this.textComponent.getHighlighter().removeAllHighlights();
                return;
            }
            this.search(word);
        }
        catch (BadLocationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void search(String word) {
        this.highlights = this.searchEngine.search(word, this.searchPanel.isCaseSensitive());
        if (!this.highlights.isEmpty()) {
            this.totalMatch = this.highlights.size();
            this.currentMatch = 0;
            this.scrollToWord(this.highlights.get(0).getStartOffset());
            this.updateHighLighter(this.currentMatch, this.currentMatch - 1);
            this.updateNavigationButtons();
        } else {
            this.searchPanel.updateCounterLabel(0, 0);
        }
    }

    private void updateNavigationButtons() {
        if (this.currentMatch == 0) {
            this.previousAction.setEnabled(false);
        } else if (this.currentMatch >= 1 && this.currentMatch <= this.totalMatch - 1) {
            this.previousAction.setEnabled(true);
        }
        if (this.currentMatch == this.totalMatch - 1) {
            this.nextAction.setEnabled(false);
        } else if (this.currentMatch < this.totalMatch - 1) {
            this.nextAction.setEnabled(true);
        }
        this.searchPanel.updateCounterLabel(this.currentMatch + 1, this.totalMatch);
    }

    private void scrollToWord(int offset) {
        try {
            this.textComponent.scrollRectToVisible(this.textComponent.modelToView(offset));
        }
        catch (BadLocationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateHighLighter(int presentIndex, int previousIndex) {
        if (previousIndex != -1) {
            this.changeHighlighter(previousIndex, PAINTER);
        }
        this.changeHighlighter(presentIndex, SELECTION_PAINTER);
    }

    private void changeHighlighter(int index, Highlighter.HighlightPainter newPainter) {
        Highlighter highlighter = this.textComponent.getHighlighter();
        Highlighter.Highlight highLight = this.highlights.get(index);
        highlighter.removeHighlight(highLight);
        try {
            highlighter.addHighlight(highLight.getStartOffset(), highLight.getEndOffset(), newPainter);
            this.highlights.set(index, highlighter.getHighlights()[highlighter.getHighlights().length - 1]);
        }
        catch (BadLocationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JCheckBox) {
            this.search(this.searchPanel.getSearchWord());
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.searchPanel.reFocus();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.textComponent.getHighlighter().removeAllHighlights();
    }

    public void addMenuListeners(PDFDebugger frame) {
        this.searchPanel.addMenuListeners(frame);
    }

    public void removeMenuListeners(PDFDebugger frame) {
        this.searchPanel.removeMenuListeners(frame);
    }
}

