/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.filter.DecodeOptions;
import org.dromara.pdf.shade.org.apache.pdfbox.filter.DecodeResult;
import org.dromara.pdf.shade.org.apache.pdfbox.filter.MissingImageReaderException;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessOutputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessRead;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadWriteBuffer;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessWrite;

public abstract class Filter {
    private static final Log LOG = LogFactory.getLog(Filter.class);
    public static final String SYSPROP_DEFLATELEVEL = "org.dromara.pdf.shade.org.apache.pdfbox.filter.deflatelevel";

    protected Filter() {
    }

    public abstract DecodeResult decode(InputStream var1, OutputStream var2, COSDictionary var3, int var4) throws IOException;

    public DecodeResult decode(InputStream encoded, OutputStream decoded, COSDictionary parameters, int index, DecodeOptions options) throws IOException {
        return this.decode(encoded, decoded, parameters, index);
    }

    public final void encode(InputStream input, OutputStream encoded, COSDictionary parameters, int index) throws IOException {
        this.encode(input, encoded, parameters.asUnmodifiableDictionary());
    }

    protected abstract void encode(InputStream var1, OutputStream var2, COSDictionary var3) throws IOException;

    protected COSDictionary getDecodeParams(COSDictionary dictionary, int index) {
        COSBase filter = dictionary.getDictionaryObject(COSName.F, COSName.FILTER);
        COSBase obj = dictionary.getDictionaryObject(COSName.DP, COSName.DECODE_PARMS);
        if (filter instanceof COSName && obj instanceof COSDictionary) {
            return (COSDictionary)obj;
        }
        if (filter instanceof COSArray && obj instanceof COSArray) {
            COSBase objAtIndex;
            COSArray array = (COSArray)obj;
            if (index < array.size() && (objAtIndex = array.getObject(index)) instanceof COSDictionary) {
                return (COSDictionary)objAtIndex;
            }
        } else if (obj != null && !(filter instanceof COSArray) && !(obj instanceof COSArray)) {
            LOG.error((Object)("Expected DecodeParams to be an Array or Dictionary but found " + obj.getClass().getName()));
        }
        return new COSDictionary();
    }

    public static final ImageReader findImageReader(String formatName, String errorCause) throws MissingImageReaderException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(formatName);
        while (readers.hasNext()) {
            ImageReader reader = readers.next();
            if (reader == null) continue;
            return reader;
        }
        throw new MissingImageReaderException("Cannot read " + formatName + " image: " + errorCause);
    }

    public static final ImageReader findRasterReader(String formatName, String errorCause) throws MissingImageReaderException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(formatName);
        while (readers.hasNext()) {
            ImageReader reader = readers.next();
            if (reader == null) continue;
            if (reader.canReadRaster()) {
                return reader;
            }
            reader.dispose();
        }
        throw new MissingImageReaderException("Cannot read " + formatName + " image: " + errorCause);
    }

    public static int getCompressionLevel() {
        int compressionLevel = -1;
        try {
            compressionLevel = Integer.parseInt(System.getProperty(SYSPROP_DEFLATELEVEL, "-1"));
        }
        catch (NumberFormatException ex) {
            LOG.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return Math.max(-1, Math.min(9, compressionLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessRead decode(InputStream encoded, List<Filter> filterList, COSDictionary parameters, DecodeOptions options, List<DecodeResult> results) throws IOException {
        HashSet<Filter> filterSet;
        long length = parameters.getLong(COSName.LENGTH, 4096L);
        if (filterList.isEmpty()) {
            throw new IllegalArgumentException("Empty filterList");
        }
        if (filterList.size() > 1 && (filterSet = new HashSet<Filter>(filterList)).size() != filterList.size()) {
            ArrayList<Filter> reducedFilterList = new ArrayList<Filter>();
            for (Filter filter : filterList) {
                if (reducedFilterList.contains(filter)) continue;
                reducedFilterList.add(filter);
            }
            filterList = reducedFilterList;
            LOG.warn((Object)"Removed duplicated filter entries");
        }
        InputStream input = encoded;
        RandomAccessReadBuffer randomAccessWriteBuffer = null;
        RandomAccessOutputStream output = null;
        for (int i = 0; i < filterList.size(); ++i) {
            if (i > 0) {
                randomAccessWriteBuffer.seek(0L);
                input = new RandomAccessInputStream(randomAccessWriteBuffer);
                length = randomAccessWriteBuffer.length();
            }
            length = length <= 0L || length >= 1024L ? 4096L : (length *= 4L);
            randomAccessWriteBuffer = new RandomAccessReadWriteBuffer((int)length);
            output = new RandomAccessOutputStream((RandomAccessWrite)((Object)randomAccessWriteBuffer));
            try {
                DecodeResult result = filterList.get(i).decode(input, output, parameters, i, options);
                if (results == null) continue;
                results.add(result);
                continue;
            }
            finally {
                IOUtils.closeQuietly(input);
            }
        }
        randomAccessWriteBuffer.seek(0L);
        return randomAccessWriteBuffer;
    }
}

