/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FlateFilterDecoderStream
extends FilterInputStream {
    private static final Log LOG = LogFactory.getLog(FlateFilterDecoderStream.class);
    private boolean isEOF = false;
    private int currentDataIndex = 0;
    private int bytesDecoded = 0;
    private byte[] buffer = new byte[2048];
    private byte[] decodedData = new byte[4096];
    private final Inflater inflater = new Inflater(true);

    public FlateFilterDecoderStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.in.read();
        this.in.read();
    }

    private boolean fetch() throws IOException {
        this.currentDataIndex = 0;
        if (this.isEOF || this.inflater.finished()) {
            this.isEOF = true;
            this.bytesDecoded = 0;
            return false;
        }
        if (this.inflater.needsInput()) {
            int bytesRead = this.in.read(this.buffer);
            if (bytesRead > -1) {
                this.inflater.setInput(this.buffer, 0, bytesRead);
            } else {
                this.isEOF = true;
                return false;
            }
        }
        try {
            if (this.bytesDecoded > 0) {
                Arrays.fill(this.decodedData, 0, this.bytesDecoded, (byte)0);
            }
            this.bytesDecoded = this.inflater.inflate(this.decodedData);
        }
        catch (DataFormatException exception) {
            this.isEOF = true;
            int countZeros = 0;
            for (int i = 0; i < this.decodedData.length; ++i) {
                if (this.decodedData[i] == 0) {
                    ++countZeros;
                    continue;
                }
                countZeros = 0;
            }
            this.bytesDecoded = this.decodedData.length - countZeros;
            LOG.warn((Object)("FlateFilter: premature end of stream due to a DataFormatException = " + exception.getMessage()));
            return this.bytesDecoded > 0;
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF) {
            return -1;
        }
        if (this.currentDataIndex == this.bytesDecoded && !this.fetch()) {
            return -1;
        }
        return this.decodedData[this.currentDataIndex++] & 0xFF;
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.isEOF) {
            return -1;
        }
        int numberOfBytesRead = 0;
        while (numberOfBytesRead < length) {
            int available = this.bytesDecoded - this.currentDataIndex;
            if (available > 0) {
                int bytes2Copy = Math.min(length - numberOfBytesRead, available);
                System.arraycopy(this.decodedData, this.currentDataIndex, data, numberOfBytesRead + offset, bytes2Copy);
                this.currentDataIndex += bytes2Copy;
                numberOfBytesRead += bytes2Copy;
                continue;
            }
            if (this.fetch()) continue;
            break;
        }
        return numberOfBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.inflater.end();
        super.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) {
        return 0L;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset is not supported");
    }
}

