/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.io.MemoryUsageSetting;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessStreamCache;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessStreamCacheImpl;

public final class IOUtils {
    private static final Log LOG = LogFactory.getLog(IOUtils.class);
    private static final RandomAccessStreamCache.StreamCacheCreateFunction streamCache = RandomAccessStreamCacheImpl::new;
    private static final Optional<Consumer<ByteBuffer>> UNMAPPER = Optional.ofNullable(AccessController.doPrivileged(IOUtils::unmapper));

    private IOUtils() {
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        IOUtils.copy(in, baout);
        return baout.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long populateBuffer(InputStream in, byte[] buffer) throws IOException {
        int bufferWritePos;
        int remaining;
        int bytesRead;
        for (remaining = buffer.length; remaining > 0 && (bytesRead = in.read(buffer, bufferWritePos = buffer.length - remaining, remaining)) >= 0; remaining -= bytesRead) {
        }
        return (long)buffer.length - (long)remaining;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)"An exception occurred while trying to close - ignoring", (Throwable)ioe);
        }
    }

    public static IOException closeAndLogException(Closeable closeable, Log logger, String resourceName, IOException initialException) {
        block2: {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                logger.warn((Object)("Error closing " + resourceName), (Throwable)ioe);
                if (initialException != null) break block2;
                return ioe;
            }
        }
        return initialException;
    }

    public static void unmap(ByteBuffer buf) {
        try {
            if (buf != null) {
                UNMAPPER.ifPresent(u -> u.accept(buf));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to unmap ByteBuffer.", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Consumer<ByteBuffer> unmapper() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return IOUtils.newBufferCleaner(ByteBuffer.class, unmapper.bindTo(theUnsafe));
        }
        catch (SecurityException se) {
            try {
                throw se;
                catch (ReflectiveOperationException | RuntimeException e) {
                    Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                    Method m = directBufferClass.getMethod("cleaner", new Class[0]);
                    m.setAccessible(true);
                    MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                    TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                    MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                    MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                    MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                    MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                    return IOUtils.newBufferCleaner(directBufferClass, unmapper);
                }
            }
            catch (SecurityException se2) {
                LOG.error((Object)"Unmapping is not supported because of missing permissions. Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\")  and ReflectPermission(\"suppressAccessChecks\")", (Throwable)se2);
                return null;
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                LOG.error((Object)"Unmapping is not supported.", (Throwable)e);
            }
        }
        return null;
    }

    private static Consumer<ByteBuffer> newBufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
        assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), unmapper.type()));
        return buffer -> {
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("unmapping only works with direct buffers");
            }
            if (!unmappableBufferClass.isInstance(buffer)) {
                throw new IllegalArgumentException("buffer is not an instance of " + unmappableBufferClass.getName());
            }
            Throwable e = AccessController.doPrivileged(() -> {
                try {
                    unmapper.invokeExact((ByteBuffer)buffer);
                    return null;
                }
                catch (Throwable t) {
                    return t;
                }
            });
            if (Objects.nonNull(e)) {
                LOG.error((Object)"Unable to unmap the mapped buffer", e);
            }
        };
    }

    public static RandomAccessStreamCache.StreamCacheCreateFunction createMemoryOnlyStreamCache() {
        return streamCache;
    }

    public static RandomAccessStreamCache.StreamCacheCreateFunction createTempFileOnlyStreamCache() {
        return MemoryUsageSetting.setupTempFileOnly().streamCache;
    }
}

