/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.io;

import java.io.IOException;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccess;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBuffer;

public class RandomAccessReadWriteBuffer
extends RandomAccessReadBuffer
implements RandomAccess {
    public RandomAccessReadWriteBuffer() {
    }

    public RandomAccessReadWriteBuffer(int definedChunkSize) {
        super(definedChunkSize);
    }

    @Override
    public void clear() throws IOException {
        this.checkClosed();
        this.resetBuffers();
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (this.chunkSize - this.currentBufferPointer <= 0) {
            this.expandBuffer();
        }
        this.currentBuffer.put((byte)b);
        ++this.currentBufferPointer;
        ++this.pointer;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int bytesToWrite;
        this.checkClosed();
        int bOff = off;
        for (int remain = len; remain > 0; remain -= bytesToWrite) {
            bytesToWrite = Math.min(remain, this.chunkSize - this.currentBufferPointer);
            if (bytesToWrite <= 0) {
                this.expandBuffer();
                bytesToWrite = Math.min(remain, this.chunkSize - this.currentBufferPointer);
            }
            if (bytesToWrite > 0) {
                this.currentBuffer.put(b, bOff, bytesToWrite);
                this.currentBufferPointer += bytesToWrite;
                this.pointer += (long)bytesToWrite;
            }
            bOff += bytesToWrite;
        }
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }
}

