/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.JBIG2ImageMetadataFormat;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.JBIG2Page;
import org.w3c.dom.Node;

public class JBIG2ImageMetadata
extends IIOMetadata {
    static final String IMAGE_METADATA_FORMAT_NAME = "jbig2";
    private final JBIG2Page page;

    public JBIG2ImageMetadata(JBIG2Page jBIG2Page) {
        super(true, IMAGE_METADATA_FORMAT_NAME, JBIG2ImageMetadataFormat.class.getName(), null, null);
        if (jBIG2Page == null) {
            throw new IllegalArgumentException("page must not be null");
        }
        this.page = jBIG2Page;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(this.nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(this.nativeMetadataFormatName);
        iIOMetadataNode.appendChild(this.getStandardDimensionNode());
        return iIOMetadataNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        iIOMetadataNode2.setAttribute("value", "1.0");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.page.getResolutionX() != 0) {
            string = Float.toString(25.4f / ((float)this.page.getResolutionX() / 39.3701f));
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (this.page.getResolutionY() != 0) {
            string = Float.toString(25.4f / ((float)this.page.getResolutionY() / 39.3701f));
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    @Override
    public void mergeTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

