/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.Bitmap;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.JBIG2Document;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.Region;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.SegmentData;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.SegmentHeader;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.err.IntegerMaxValueException;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.err.JBIG2Exception;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.image.Bitmaps;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.EndOfStripe;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.PageInformation;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.util.CombinationOperator;

class JBIG2Page {
    private final Map<Integer, SegmentHeader> segments = new TreeMap<Integer, SegmentHeader>();
    private final int pageNumber;
    private Bitmap pageBitmap;
    private int finalHeight;
    private int finalWidth;
    private int resolutionX;
    private int resolutionY;
    private final JBIG2Document document;

    protected JBIG2Page(JBIG2Document jBIG2Document, int n) {
        this.document = jBIG2Document;
        this.pageNumber = n;
    }

    public SegmentHeader getSegment(int n) {
        SegmentHeader segmentHeader = this.segments.get(n);
        if (null != segmentHeader) {
            return segmentHeader;
        }
        if (null != this.document) {
            return this.document.getGlobalSegment(n);
        }
        return null;
    }

    protected SegmentHeader getPageInformationSegment() {
        for (SegmentHeader segmentHeader : this.segments.values()) {
            if (segmentHeader.getSegmentType() != 48) continue;
            return segmentHeader;
        }
        return null;
    }

    protected Bitmap getBitmap() throws JBIG2Exception, IOException {
        if (null == this.pageBitmap) {
            this.composePageBitmap();
        }
        return this.pageBitmap;
    }

    private void composePageBitmap() throws IOException, JBIG2Exception {
        if (this.pageNumber > 0) {
            PageInformation pageInformation = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.createPage(pageInformation);
            this.clearSegmentData();
        }
    }

    private void createPage(PageInformation pageInformation) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (!pageInformation.isStriped() || pageInformation.getHeight() != -1) {
            this.createNormalPage(pageInformation);
        } else {
            this.createStripedPage(pageInformation);
        }
    }

    private void createNormalPage(PageInformation pageInformation) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        this.pageBitmap = new Bitmap(pageInformation.getWidth(), pageInformation.getHeight());
        if (pageInformation.getDefaultPixelValue() != 0) {
            this.pageBitmap.fillBitmap((byte)-1);
        }
        for (SegmentHeader segmentHeader : this.segments.values()) {
            switch (segmentHeader.getSegmentType()) {
                case 6: 
                case 7: 
                case 22: 
                case 23: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    Region region = (Region)segmentHeader.getSegmentData();
                    Bitmap bitmap = region.getRegionBitmap();
                    if (this.fitsPage(pageInformation, bitmap)) {
                        this.pageBitmap = bitmap;
                        break;
                    }
                    RegionSegmentInformation regionSegmentInformation = region.getRegionInfo();
                    CombinationOperator combinationOperator = this.getCombinationOperator(pageInformation, regionSegmentInformation.getCombinationOperator());
                    Bitmaps.blit(bitmap, this.pageBitmap, regionSegmentInformation.getXLocation(), regionSegmentInformation.getYLocation(), combinationOperator);
                }
            }
        }
    }

    private boolean fitsPage(PageInformation pageInformation, Bitmap bitmap) {
        return this.countRegions() == 1 && pageInformation.getDefaultPixelValue() == 0 && pageInformation.getWidth() == bitmap.getWidth() && pageInformation.getHeight() == bitmap.getHeight();
    }

    private void createStripedPage(PageInformation pageInformation) throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        ArrayList<SegmentData> arrayList = this.collectPageStripes();
        this.pageBitmap = new Bitmap(pageInformation.getWidth(), this.finalHeight);
        int n = 0;
        for (SegmentData segmentData : arrayList) {
            if (segmentData instanceof EndOfStripe) {
                n = ((EndOfStripe)segmentData).getLineNumber() + 1;
                continue;
            }
            Region region = (Region)segmentData;
            RegionSegmentInformation regionSegmentInformation = region.getRegionInfo();
            CombinationOperator combinationOperator = this.getCombinationOperator(pageInformation, regionSegmentInformation.getCombinationOperator());
            Bitmaps.blit(region.getRegionBitmap(), this.pageBitmap, regionSegmentInformation.getXLocation(), n, combinationOperator);
        }
    }

    private ArrayList<SegmentData> collectPageStripes() {
        ArrayList<SegmentData> arrayList = new ArrayList<SegmentData>();
        for (SegmentHeader segmentHeader : this.segments.values()) {
            switch (segmentHeader.getSegmentType()) {
                case 6: 
                case 7: 
                case 22: 
                case 23: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    Region region = (Region)segmentHeader.getSegmentData();
                    arrayList.add(region);
                    break;
                }
                case 50: {
                    EndOfStripe endOfStripe = (EndOfStripe)segmentHeader.getSegmentData();
                    arrayList.add(endOfStripe);
                    this.finalHeight = endOfStripe.getLineNumber() + 1;
                }
            }
        }
        return arrayList;
    }

    private int countRegions() {
        int n = 0;
        for (SegmentHeader segmentHeader : this.segments.values()) {
            switch (segmentHeader.getSegmentType()) {
                case 6: 
                case 7: 
                case 22: 
                case 23: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    ++n;
                }
            }
        }
        return n;
    }

    private CombinationOperator getCombinationOperator(PageInformation pageInformation, CombinationOperator combinationOperator) {
        if (pageInformation.isCombinationOperatorOverrideAllowed()) {
            return combinationOperator;
        }
        return pageInformation.getCombinationOperator();
    }

    protected void add(SegmentHeader segmentHeader) {
        this.segments.put(segmentHeader.getSegmentNr(), segmentHeader);
    }

    private void clearSegmentData() {
        Set<Integer> set = this.segments.keySet();
        for (Integer n : set) {
            this.segments.get(n).cleanSegmentData();
        }
    }

    protected void clearPageData() {
        this.pageBitmap = null;
    }

    protected int getHeight() throws IOException, JBIG2Exception {
        if (this.finalHeight == 0) {
            PageInformation pageInformation = (PageInformation)this.getPageInformationSegment().getSegmentData();
            if (pageInformation.getHeight() == -1) {
                this.getBitmap();
            } else {
                this.finalHeight = pageInformation.getHeight();
            }
        }
        return this.finalHeight;
    }

    protected int getWidth() {
        if (this.finalWidth == 0) {
            PageInformation pageInformation = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.finalWidth = pageInformation.getWidth();
        }
        return this.finalWidth;
    }

    protected int getResolutionX() {
        if (this.resolutionX == 0) {
            PageInformation pageInformation = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.resolutionX = pageInformation.getResolutionX();
        }
        return this.resolutionX;
    }

    protected int getResolutionY() {
        if (this.resolutionY == 0) {
            PageInformation pageInformation = (PageInformation)this.getPageInformationSegment().getSegmentData();
            this.resolutionY = pageInformation.getResolutionY();
        }
        return this.resolutionY;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (Page number: " + this.pageNumber + ")";
    }
}

