/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.JBIG2Document;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.JBIG2Page;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.SegmentData;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.io.SubInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.EndOfStripe;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.GenericRefinementRegion;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.GenericRegion;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.HalftoneRegion;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.PageInformation;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.PatternDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.Profiles;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.SymbolDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.Table;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.segments.TextRegion;

public class SegmentHeader {
    private static final Map<Integer, Class<? extends SegmentData>> SEGMENT_TYPE_MAP = new HashMap<Integer, Class<? extends SegmentData>>();
    private int segmentNr;
    private int segmentType;
    private byte retainFlag;
    private int pageAssociation;
    private byte pageAssociationFieldSize;
    private SegmentHeader[] rtSegments;
    private long segmentHeaderLength;
    private long segmentDataLength;
    private long segmentDataStartOffset;
    private final SubInputStream subInputStream;
    private Reference<SegmentData> segmentData;

    public SegmentHeader(JBIG2Document jBIG2Document, SubInputStream subInputStream, long l, int n) throws IOException {
        this.subInputStream = subInputStream;
        this.parse(jBIG2Document, subInputStream, l, n);
    }

    private void parse(JBIG2Document jBIG2Document, ImageInputStream imageInputStream, long l, int n) throws IOException {
        imageInputStream.seek(l);
        this.readSegmentNumber(imageInputStream);
        this.readSegmentHeaderFlag(imageInputStream);
        int n2 = this.readAmountOfReferredToSegments(imageInputStream);
        int[] nArray = this.readReferredToSegmentsNumbers(imageInputStream, n2);
        this.readSegmentPageAssociation(jBIG2Document, imageInputStream, n2, nArray);
        this.readSegmentDataLength(imageInputStream);
        this.readDataStartOffset(imageInputStream, n);
        this.readSegmentHeaderLength(imageInputStream, l);
    }

    private void readSegmentNumber(ImageInputStream imageInputStream) throws IOException {
        this.segmentNr = (int)(imageInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
    }

    private void readSegmentHeaderFlag(ImageInputStream imageInputStream) throws IOException {
        this.retainFlag = (byte)imageInputStream.readBit();
        this.pageAssociationFieldSize = (byte)imageInputStream.readBit();
        this.segmentType = (int)(imageInputStream.readBits(6) & 0xFFL);
    }

    private int readAmountOfReferredToSegments(ImageInputStream imageInputStream) throws IOException {
        int n = (int)(imageInputStream.readBits(3) & 0xFL);
        if (n <= 4) {
            byte[] byArray = new byte[5];
            for (int i = 0; i <= 4; ++i) {
                byArray[i] = (byte)imageInputStream.readBit();
            }
        } else {
            n = (int)(imageInputStream.readBits(29) & 0xFFFFFFFFFFFFFFFFL);
            int n2 = n + 8 >> 3;
            byte[] byArray = new byte[n2 <<= 3];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)imageInputStream.readBit();
            }
        }
        return n;
    }

    private int[] readReferredToSegmentsNumbers(ImageInputStream imageInputStream, int n) throws IOException {
        int[] nArray = new int[n];
        if (n > 0) {
            int n2 = 1;
            if (this.segmentNr > 256) {
                n2 = 2;
                if (this.segmentNr > 65536) {
                    n2 = 4;
                }
            }
            this.rtSegments = new SegmentHeader[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)(imageInputStream.readBits(n2 << 3) & 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return nArray;
    }

    private void readSegmentPageAssociation(JBIG2Document jBIG2Document, ImageInputStream imageInputStream, int n, int[] nArray) throws IOException {
        this.pageAssociation = this.pageAssociationFieldSize == 0 ? (int)((short)(imageInputStream.readBits(8) & 0xFFL)) : (int)(imageInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        if (n > 0) {
            JBIG2Page jBIG2Page = jBIG2Document.getPage(this.pageAssociation);
            for (int i = 0; i < n; ++i) {
                this.rtSegments[i] = null != jBIG2Page ? jBIG2Page.getSegment(nArray[i]) : jBIG2Document.getGlobalSegment(nArray[i]);
            }
        }
    }

    private void readSegmentDataLength(ImageInputStream imageInputStream) throws IOException {
        this.segmentDataLength = imageInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL;
    }

    private void readDataStartOffset(ImageInputStream imageInputStream, int n) throws IOException {
        if (n == 1) {
            this.segmentDataStartOffset = imageInputStream.getStreamPosition();
        }
    }

    private void readSegmentHeaderLength(ImageInputStream imageInputStream, long l) throws IOException {
        this.segmentHeaderLength = imageInputStream.getStreamPosition() - l;
    }

    public int getSegmentNr() {
        return this.segmentNr;
    }

    public int getSegmentType() {
        return this.segmentType;
    }

    public long getSegmentHeaderLength() {
        return this.segmentHeaderLength;
    }

    public long getSegmentDataLength() {
        return this.segmentDataLength;
    }

    public long getSegmentDataStartOffset() {
        return this.segmentDataStartOffset;
    }

    public void setSegmentDataStartOffset(long l) {
        this.segmentDataStartOffset = l;
    }

    public SegmentHeader[] getRtSegments() {
        return this.rtSegments;
    }

    public int getPageAssociation() {
        return this.pageAssociation;
    }

    public short getRetainFlag() {
        return this.retainFlag;
    }

    public SubInputStream getDataInputStream() {
        return new SubInputStream(this.subInputStream, this.segmentDataStartOffset, this.segmentDataLength);
    }

    public SegmentData getSegmentData() {
        SegmentData segmentData = null;
        if (null != this.segmentData) {
            segmentData = this.segmentData.get();
        }
        if (null == segmentData) {
            try {
                Class<? extends SegmentData> clazz = SEGMENT_TYPE_MAP.get(this.segmentType);
                if (null == clazz) {
                    throw new IllegalArgumentException("No segment class for type " + this.segmentType);
                }
                segmentData = clazz.newInstance();
                segmentData.init(this, this.getDataInputStream());
                this.segmentData = new SoftReference<SegmentData>(segmentData);
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't instantiate segment class", exception);
            }
        }
        return segmentData;
    }

    public void cleanSegmentData() {
        if (this.segmentData != null) {
            this.segmentData = null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.rtSegments != null) {
            for (SegmentHeader segmentHeader : this.rtSegments) {
                stringBuilder.append(segmentHeader.segmentNr + " ");
            }
        } else {
            stringBuilder.append("none");
        }
        return "\n#SegmentNr: " + this.segmentNr + "\n SegmentType: " + this.segmentType + "\n PageAssociation: " + this.pageAssociation + "\n Referred-to segments: " + stringBuilder.toString() + "\n";
    }

    static {
        Object[][] objectArrayArray = new Object[][]{{0, SymbolDictionary.class}, {4, TextRegion.class}, {6, TextRegion.class}, {7, TextRegion.class}, {16, PatternDictionary.class}, {20, HalftoneRegion.class}, {22, HalftoneRegion.class}, {23, HalftoneRegion.class}, {36, GenericRegion.class}, {38, GenericRegion.class}, {39, GenericRegion.class}, {40, GenericRefinementRegion.class}, {42, GenericRefinementRegion.class}, {43, GenericRefinementRegion.class}, {48, PageInformation.class}, {50, EndOfStripe.class}, {52, Profiles.class}, {53, Table.class}};
        for (int i = 0; i < objectArrayArray.length; ++i) {
            Object[] objectArray = objectArrayArray[i];
            SEGMENT_TYPE_MAP.put((Integer)objectArray[0], (Class)objectArray[1]);
        }
    }
}

