/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.InternalNode;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.ValueNode;

public abstract class HuffmanTable {
    private InternalNode rootNode = new InternalNode();

    public void initTree(List<Code> list) {
        this.preprocessCodes(list);
        for (Code code : list) {
            this.rootNode.append(code);
        }
    }

    public long decode(ImageInputStream imageInputStream) throws IOException {
        return this.rootNode.decode(imageInputStream);
    }

    public String toString() {
        return this.rootNode + "\n";
    }

    public static String codeTableToString(List<Code> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Code code : list) {
            stringBuilder.append(code.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void preprocessCodes(List<Code> list) {
        int n = 0;
        for (Code object2 : list) {
            n = Math.max(n, object2.prefixLength);
        }
        Object object3 = new int[n + 1];
        for (Code code : list) {
            Object object = object3;
            int n2 = code.prefixLength;
            object[n2] = object[n2] + true;
        }
        int[] nArray = new int[((Object)object3).length + 1];
        object3[0] = false;
        for (int i = 1; i <= ((Object)object3).length; ++i) {
            nArray[i] = nArray[i - 1] + object3[i - 1] << 1;
            int n3 = nArray[i];
            for (Code code : list) {
                void var4_7;
                if (code.prefixLength != i) continue;
                code.code = var4_7++;
            }
        }
    }

    public static class Code {
        final int prefixLength;
        final int rangeLength;
        final int rangeLow;
        final boolean isLowerRange;
        int code = -1;

        public Code(int n, int n2, int n3, boolean bl) {
            this.prefixLength = n;
            this.rangeLength = n2;
            this.rangeLow = n3;
            this.isLowerRange = bl;
        }

        public String toString() {
            return (this.code != -1 ? ValueNode.bitPattern(this.code, this.prefixLength) : "?") + "/" + this.prefixLength + "/" + this.rangeLength + "/" + this.rangeLow;
        }
    }
}

