/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.Node;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.OutOfBandNode;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.ValueNode;

class InternalNode
extends Node {
    private final int depth;
    private Node zero;
    private Node one;

    protected InternalNode() {
        this.depth = 0;
    }

    protected InternalNode(int n) {
        this.depth = n;
    }

    protected void append(HuffmanTable.Code code) {
        if (code.prefixLength == 0) {
            return;
        }
        int n = code.prefixLength - 1 - this.depth;
        if (n < 0) {
            throw new IllegalArgumentException("Negative shifting is not possible.");
        }
        int n2 = code.code >> n & 1;
        if (n == 0) {
            if (code.rangeLength == -1) {
                if (n2 == 1) {
                    if (this.one != null) {
                        throw new IllegalStateException("already have a OOB for " + code);
                    }
                    this.one = new OutOfBandNode(code);
                } else {
                    if (this.zero != null) {
                        throw new IllegalStateException("already have a OOB for " + code);
                    }
                    this.zero = new OutOfBandNode(code);
                }
            } else if (n2 == 1) {
                if (this.one != null) {
                    throw new IllegalStateException("already have a ValueNode for " + code);
                }
                this.one = new ValueNode(code);
            } else {
                if (this.zero != null) {
                    throw new IllegalStateException("already have a ValueNode for " + code);
                }
                this.zero = new ValueNode(code);
            }
        } else if (n2 == 1) {
            if (this.one == null) {
                this.one = new InternalNode(this.depth + 1);
            }
            ((InternalNode)this.one).append(code);
        } else {
            if (this.zero == null) {
                this.zero = new InternalNode(this.depth + 1);
            }
            ((InternalNode)this.zero).append(code);
        }
    }

    @Override
    protected long decode(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readBit();
        Node node = n == 0 ? this.zero : this.one;
        return node.decode(imageInputStream);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\n");
        this.pad(stringBuilder);
        stringBuilder.append("0: ").append(this.zero).append("\n");
        this.pad(stringBuilder);
        stringBuilder.append("1: ").append(this.one).append("\n");
        return stringBuilder.toString();
    }

    private void pad(StringBuilder stringBuilder) {
        for (int i = 0; i < this.depth; ++i) {
            stringBuilder.append("   ");
        }
    }
}

