/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.decoder.huffman.Node;

class ValueNode
extends Node {
    private int rangeLen;
    private int rangeLow;
    private boolean isLowerRange;

    protected ValueNode(HuffmanTable.Code code) {
        this.rangeLen = code.rangeLength;
        this.rangeLow = code.rangeLow;
        this.isLowerRange = code.isLowerRange;
    }

    @Override
    protected long decode(ImageInputStream imageInputStream) throws IOException {
        if (this.isLowerRange) {
            return (long)this.rangeLow - imageInputStream.readBits(this.rangeLen);
        }
        return (long)this.rangeLow + imageInputStream.readBits(this.rangeLen);
    }

    static String bitPattern(int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 1; i <= n2; ++i) {
            cArray[i - 1] = (n >> n2 - i & 1) != 0 ? 49 : 48;
        }
        return new String(cArray);
    }
}

