/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.jbig2.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.imageio.ImageReadParam;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.Bitmap;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.JBIG2ReadParam;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.image.Filter;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.image.FilterType;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.image.Resizer;
import org.dromara.pdf.shade.org.apache.pdfbox.jbig2.util.CombinationOperator;

public class Bitmaps {
    public static WritableRaster asRaster(Bitmap bitmap) {
        return Bitmaps.asRaster(bitmap, FilterType.Gaussian);
    }

    public static WritableRaster asRaster(Bitmap bitmap, FilterType filterType) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        JBIG2ReadParam jBIG2ReadParam = new JBIG2ReadParam(1, 1, 0, 0, new Rectangle(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Dimension(bitmap.getWidth(), bitmap.getHeight()));
        return Bitmaps.asRaster(bitmap, jBIG2ReadParam, filterType);
    }

    public static WritableRaster asRaster(Bitmap bitmap, ImageReadParam imageReadParam, FilterType filterType) {
        boolean bl;
        double d;
        double d2;
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        if (imageReadParam == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        Dimension dimension = imageReadParam.getSourceRenderSize();
        if (dimension != null) {
            d2 = dimension.getWidth() / (double)bitmap.getWidth();
            d = dimension.getHeight() / (double)bitmap.getHeight();
        } else {
            d = 1.0;
            d2 = 1.0;
        }
        Rectangle rectangle = imageReadParam.getSourceRegion();
        if (rectangle != null && !bitmap.getBounds().equals(rectangle)) {
            rectangle = bitmap.getBounds().intersection(rectangle);
            bitmap = Bitmaps.extract(rectangle, bitmap);
        }
        boolean bl2 = d2 != 1.0 || d != 1.0;
        boolean bl3 = imageReadParam.getSourceXSubsampling() != 1;
        boolean bl4 = bl = imageReadParam.getSourceYSubsampling() != 1;
        if (bl3 && bl) {
            if (bl2) {
                d2 /= (double)imageReadParam.getSourceXSubsampling();
                d /= (double)imageReadParam.getSourceYSubsampling();
            } else {
                bitmap = Bitmaps.subsample(bitmap, imageReadParam);
            }
        } else {
            if (bl3) {
                if (bl2) {
                    d2 /= (double)imageReadParam.getSourceXSubsampling();
                } else {
                    bitmap = Bitmaps.subsampleX(bitmap, imageReadParam.getSourceXSubsampling(), imageReadParam.getSubsamplingXOffset());
                }
            }
            if (bl) {
                if (bl2) {
                    d /= (double)imageReadParam.getSourceYSubsampling();
                } else {
                    bitmap = Bitmaps.subsampleY(bitmap, imageReadParam.getSourceYSubsampling(), imageReadParam.getSubsamplingYOffset());
                }
            }
        }
        return Bitmaps.buildRaster(bitmap, filterType, d2, d);
    }

    private static WritableRaster buildRaster(Bitmap bitmap, FilterType filterType, double d, double d2) {
        WritableRaster writableRaster;
        int n = bitmap.getHeight();
        int n2 = bitmap.getWidth();
        if (d != 1.0 || d2 != 1.0) {
            Rectangle rectangle = new Rectangle(0, 0, (int)Math.round((double)n2 * d), (int)Math.round((double)n * d2));
            writableRaster = Raster.createInterleavedRaster(0, rectangle.width, rectangle.height, 1, new Point());
            Resizer resizer = new Resizer(d, d2);
            Filter filter = Filter.byType(filterType);
            resizer.resize(bitmap, bitmap.getBounds(), writableRaster, rectangle, filter, filter);
        } else {
            int n3 = n2 / 8;
            int n4 = -256 >> (n2 & 7) & 0xFF;
            byte[] byArray = new byte[n * bitmap.getRowStride()];
            int n5 = 0;
            for (int i = n; i > 0; --i) {
                for (int j = n3; j > 0; --j) {
                    byArray[n5] = ~bitmap.getByte(n5++);
                }
                if (n4 == 0) continue;
                byArray[n5] = (byte)(~bitmap.getByte(n5++) & n4);
            }
            writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n2, n, 1, new Point());
        }
        return writableRaster;
    }

    public static BufferedImage asBufferedImage(Bitmap bitmap) {
        return Bitmaps.asBufferedImage(bitmap, FilterType.Gaussian);
    }

    public static BufferedImage asBufferedImage(Bitmap bitmap, FilterType filterType) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        JBIG2ReadParam jBIG2ReadParam = new JBIG2ReadParam(1, 1, 0, 0, new Rectangle(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Dimension(bitmap.getWidth(), bitmap.getHeight()));
        return Bitmaps.asBufferedImage(bitmap, jBIG2ReadParam, filterType);
    }

    public static BufferedImage asBufferedImage(Bitmap bitmap, ImageReadParam imageReadParam, FilterType filterType) {
        boolean bl;
        double d;
        double d2;
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        if (imageReadParam == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        WritableRaster writableRaster = Bitmaps.asRaster(bitmap, imageReadParam, filterType);
        Dimension dimension = imageReadParam.getSourceRenderSize();
        if (dimension != null) {
            d2 = dimension.getWidth() / (double)bitmap.getWidth();
            d = dimension.getHeight() / (double)bitmap.getHeight();
        } else {
            d = 1.0;
            d2 = 1.0;
        }
        IndexColorModel indexColorModel = null;
        boolean bl2 = bl = d2 != 1.0 || d != 1.0;
        if (bl) {
            byte[] byArray = new byte[256];
            int n = 255;
            int n2 = 0;
            while (n >= 0) {
                byArray[n] = (byte)(255 - n2 * 255 / 255);
                --n;
                ++n2;
            }
            indexColorModel = new IndexColorModel(8, 256, byArray, byArray, byArray);
        } else {
            indexColorModel = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
        }
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    public static Bitmap extract(Rectangle rectangle, Bitmap bitmap) {
        Bitmap bitmap2 = new Bitmap(rectangle.width, rectangle.height);
        int n = rectangle.x & 7;
        int n2 = 8 - n;
        int n3 = 0;
        int n4 = 8 - bitmap2.getWidth() & 7;
        int n5 = bitmap.getByteIndex(rectangle.x, rectangle.y);
        int n6 = bitmap.getByteIndex(rectangle.x + rectangle.width - 1, rectangle.y);
        boolean bl = bitmap2.getRowStride() == n6 + 1 - n5;
        int n7 = rectangle.y;
        while ((double)n7 < rectangle.getMaxY()) {
            int n8;
            int n9 = n5;
            int n10 = n3;
            if (n5 == n6) {
                n8 = (byte)(bitmap.getByte(n9) << n);
                bitmap2.setByte(n10, Bitmaps.unpad(n4, (byte)n8));
            } else if (n == 0) {
                for (n8 = n5; n8 <= n6; ++n8) {
                    byte by = bitmap.getByte(n9++);
                    if (n8 == n6 && bl) {
                        by = Bitmaps.unpad(n4, by);
                    }
                    bitmap2.setByte(n10++, by);
                }
            } else {
                Bitmaps.copyLine(bitmap, bitmap2, n, n2, n4, n5, n6, bl, n9, n10);
            }
            n5 += bitmap.getRowStride();
            n6 += bitmap.getRowStride();
            n3 += bitmap2.getRowStride();
            ++n7;
        }
        return bitmap2;
    }

    private static void copyLine(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        for (int i = n4; i < n5; ++i) {
            byte by;
            if (n6 + 1 < bitmap.getLength()) {
                by = i + 1 == n5 ? (byte)1 : 0;
                byte by2 = (byte)(bitmap.getByte(n6++) << n | (bitmap.getByte(n6) & 0xFF) >>> n2);
                if (by != 0 && !bl) {
                    by2 = Bitmaps.unpad(n3, by2);
                }
                bitmap2.setByte(n7++, by2);
                if (by == 0 || !bl) continue;
                by2 = Bitmaps.unpad(n3, (byte)((bitmap.getByte(n6) & 0xFF) << n));
                bitmap2.setByte(n7, by2);
                continue;
            }
            by = (byte)(bitmap.getByte(n6++) << n & 0xFF);
            bitmap2.setByte(n7++, by);
        }
    }

    private static byte unpad(int n, byte by) {
        return (byte)(by >> n << n);
    }

    public static Bitmap subsample(Bitmap bitmap, ImageReadParam imageReadParam) {
        if (bitmap == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        if (imageReadParam == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        int n = imageReadParam.getSourceXSubsampling();
        int n2 = imageReadParam.getSourceYSubsampling();
        int n3 = imageReadParam.getSubsamplingXOffset();
        int n4 = imageReadParam.getSubsamplingYOffset();
        int n5 = (bitmap.getWidth() - n3) / n;
        int n6 = (bitmap.getHeight() - n4) / n2;
        Bitmap bitmap2 = new Bitmap(n5, n6);
        int n7 = 0;
        int n8 = n4;
        while (n7 < bitmap2.getHeight()) {
            int n9 = 0;
            int n10 = n3;
            while (n9 < bitmap2.getWidth()) {
                byte by = bitmap.getPixel(n10, n8);
                if (by != 0) {
                    bitmap2.setPixel(n9, n7, by);
                }
                ++n9;
                n10 += n;
            }
            ++n7;
            n8 += n2;
        }
        return bitmap2;
    }

    public static Bitmap subsampleX(Bitmap bitmap, int n, int n2) {
        if (bitmap == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        int n3 = (bitmap.getWidth() - n2) / n;
        Bitmap bitmap2 = new Bitmap(bitmap.getWidth(), n3);
        for (int i = 0; i < bitmap2.getHeight(); ++i) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < bitmap2.getWidth()) {
                byte by = bitmap.getPixel(n5, i);
                if (by != 0) {
                    bitmap2.setPixel(n4, i, by);
                }
                ++n4;
                n5 += n;
            }
        }
        return bitmap2;
    }

    public static Bitmap subsampleY(Bitmap bitmap, int n, int n2) {
        if (bitmap == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        int n3 = (bitmap.getWidth() - n2) / n;
        Bitmap bitmap2 = new Bitmap(n3, bitmap.getHeight());
        int n4 = 0;
        int n5 = n2;
        while (n4 < bitmap2.getHeight()) {
            for (int i = 0; i < bitmap2.getWidth(); ++i) {
                byte by = bitmap.getPixel(i, n5);
                if (by == 0) continue;
                bitmap2.setPixel(i, n4, by);
            }
            ++n4;
            n5 += n;
        }
        return bitmap2;
    }

    public static byte combineBytes(byte by, byte by2, CombinationOperator combinationOperator) {
        switch (combinationOperator) {
            case OR: {
                return (byte)(by2 | by);
            }
            case AND: {
                return (byte)(by2 & by);
            }
            case XOR: {
                return (byte)(by2 ^ by);
            }
            case XNOR: {
                return (byte)(~(by ^ by2));
            }
        }
        return by2;
    }

    public static void blit(Bitmap bitmap, Bitmap bitmap2, int n, int n2, CombinationOperator combinationOperator) {
        int n3 = 0;
        int n4 = 0;
        int n5 = bitmap.getRowStride() - 1;
        if (n < 0) {
            n4 = -n;
            n = 0;
        } else if (n + bitmap.getWidth() > bitmap2.getWidth()) {
            n5 -= bitmap.getWidth() + n - bitmap2.getWidth();
        }
        if (n2 < 0) {
            n3 = -n2;
            n2 = 0;
            n4 += bitmap.getRowStride();
            n5 += bitmap.getRowStride();
        } else if (n2 + bitmap.getHeight() > bitmap2.getHeight()) {
            n3 = bitmap.getHeight() + n2 - bitmap2.getHeight();
        }
        int n6 = n & 7;
        int n7 = 8 - n6;
        int n8 = bitmap.getWidth() & 7;
        int n9 = n7 - n8;
        boolean bl = (n7 & 7) != 0;
        boolean bl2 = bitmap.getWidth() <= (n5 - n4 << 3) + n7;
        int n10 = bitmap2.getByteIndex(n, n2);
        int n11 = Math.min(bitmap.getHeight(), n3 + bitmap2.getHeight());
        if (!bl) {
            Bitmaps.blitUnshifted(bitmap, bitmap2, n3, n11, n10, n4, n5, combinationOperator);
        } else if (bl2) {
            Bitmaps.blitSpecialShifted(bitmap, bitmap2, n3, n11, n10, n4, n5, n9, n6, n7, combinationOperator);
        } else {
            Bitmaps.blitShifted(bitmap, bitmap2, n3, n11, n10, n4, n5, n9, n6, n7, combinationOperator, n8);
        }
    }

    private static void blitUnshifted(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, int n4, int n5, CombinationOperator combinationOperator) {
        int n6 = n5 - n4 + 1;
        int n7 = n4;
        int n8 = n3;
        for (int i = n2 - n; i > 0; --i) {
            int n9 = n7;
            int n10 = n8;
            int n11 = n6;
            switch (combinationOperator) {
                case OR: 
                case AND: 
                case XOR: 
                case XNOR: {
                    while (n11-- > 0) {
                        bitmap2.setByte(n10, Bitmaps.combineBytes(bitmap.getByte(n9++), bitmap2.getByte(n10++), combinationOperator));
                    }
                    break;
                }
                case REPLACE: {
                    Bitmap.arraycopy(bitmap, n9, bitmap2, n10, n11);
                    break;
                }
            }
            n7 += bitmap.getRowStride();
            n8 += bitmap2.getRowStride();
        }
    }

    private static void blitSpecialShifted(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, CombinationOperator combinationOperator) {
        int n9 = n;
        while (n9 < n2) {
            int n10 = 0;
            int n11 = n3;
            for (int i = n4; i <= n5; ++i) {
                byte by = bitmap2.getByte(n11);
                n10 = (short)((n10 | bitmap.getByte(i) & 0xFF) << n8);
                byte by2 = (byte)(n10 >> 8);
                if (i == n5) {
                    by2 = Bitmaps.unpad(n6, by2);
                }
                bitmap2.setByte(n11++, Bitmaps.combineBytes(by, by2, combinationOperator));
                n10 = (short)(n10 << n7);
            }
            ++n9;
            n3 += bitmap2.getRowStride();
            n4 += bitmap.getRowStride();
            n5 += bitmap.getRowStride();
        }
    }

    private static void blitShifted(Bitmap bitmap, Bitmap bitmap2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, CombinationOperator combinationOperator, int n9) {
        int n10 = n;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n3;
            for (int i = n4; i <= n5; ++i) {
                byte by = bitmap2.getByte(n12);
                n11 = (short)((n11 | bitmap.getByte(i) & 0xFF) << n8);
                byte by2 = (byte)(n11 >> 8);
                bitmap2.setByte(n12++, Bitmaps.combineBytes(by, by2, combinationOperator));
                n11 = (short)(n11 << n7);
                if (i != n5) continue;
                by2 = (byte)(n11 >> 8 - n8);
                if (n9 != 0) {
                    by2 = Bitmaps.unpad(8 + n6, by2);
                }
                by = bitmap2.getByte(n12);
                bitmap2.setByte(n12, Bitmaps.combineBytes(by, by2, combinationOperator));
            }
            ++n10;
            n3 += bitmap2.getRowStride();
            n4 += bitmap.getRowStride();
            n5 += bitmap.getRowStride();
        }
    }
}

