/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSObjectKey;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfparser.BaseParser;

public class PDFObjectStreamParser
extends BaseParser {
    private final int numberOfObjects;
    private final int firstObject;

    public PDFObjectStreamParser(COSStream stream, COSDocument document) throws IOException {
        super(stream.createView());
        this.document = document;
        this.numberOfObjects = stream.getInt(COSName.N);
        if (this.numberOfObjects == -1) {
            throw new IOException("/N entry missing in object stream");
        }
        if (this.numberOfObjects < 0) {
            throw new IOException("Illegal /N entry in object stream: " + this.numberOfObjects);
        }
        this.firstObject = stream.getInt(COSName.FIRST);
        if (this.firstObject == -1) {
            throw new IOException("/First entry missing in object stream");
        }
        if (this.firstObject < 0) {
            throw new IOException("Illegal /First entry in object stream: " + this.firstObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COSBase parseObject(long objectNumber) throws IOException {
        COSBase streamObject = null;
        try {
            Integer objectOffset = this.privateReadObjectNumbers().get(objectNumber);
            if (objectOffset != null) {
                long currentPosition = this.source.getPosition();
                if (this.firstObject > 0 && currentPosition < (long)this.firstObject) {
                    this.source.skip(this.firstObject - (int)currentPosition);
                }
                this.source.skip(objectOffset);
                streamObject = this.parseDirObject();
                if (streamObject != null) {
                    streamObject.setDirect(false);
                }
            }
        }
        finally {
            this.source.close();
            this.document = null;
        }
        return streamObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<COSObjectKey, COSBase> parseAllObjects() throws IOException {
        HashMap<COSObjectKey, COSBase> allObjects = new HashMap<COSObjectKey, COSBase>();
        try {
            Map<Integer, Long> objectNumbers = this.privateReadObjectOffsets();
            long numberOfObjNumbers = objectNumbers.values().stream().distinct().count();
            boolean indexNeeded = (long)objectNumbers.size() > numberOfObjNumbers;
            long currentPosition = this.source.getPosition();
            if (this.firstObject > 0 && currentPosition < (long)this.firstObject) {
                this.source.skip(this.firstObject - (int)currentPosition);
            }
            int index = 0;
            for (Map.Entry<Integer, Long> entry : objectNumbers.entrySet()) {
                COSBase streamObject;
                COSObjectKey objectKey = this.getObjectKey(entry.getValue(), 0);
                if (indexNeeded && objectKey.getStreamIndex() > -1 && objectKey.getStreamIndex() != index) {
                    ++index;
                    continue;
                }
                int finalPosition = this.firstObject + entry.getKey();
                currentPosition = this.source.getPosition();
                if (finalPosition > 0 && currentPosition < (long)finalPosition) {
                    this.source.skip(finalPosition - (int)currentPosition);
                }
                if ((streamObject = this.parseDirObject()) != null) {
                    streamObject.setDirect(false);
                }
                allObjects.put(objectKey, streamObject);
                ++index;
            }
        }
        finally {
            this.source.close();
            this.document = null;
        }
        return allObjects;
    }

    private Map<Long, Integer> privateReadObjectNumbers() throws IOException {
        HashMap<Long, Integer> objectNumbers = new HashMap<Long, Integer>();
        long firstObjectPosition = this.source.getPosition() + (long)this.firstObject - 1L;
        for (int i = 0; i < this.numberOfObjects && this.source.getPosition() < firstObjectPosition; ++i) {
            long objectNumber = this.readObjectNumber();
            int offset = (int)this.readLong();
            objectNumbers.put(objectNumber, offset);
        }
        return objectNumbers;
    }

    private Map<Integer, Long> privateReadObjectOffsets() throws IOException {
        TreeMap<Integer, Long> objectOffsets = new TreeMap<Integer, Long>();
        long firstObjectPosition = this.source.getPosition() + (long)this.firstObject - 1L;
        for (int i = 0; i < this.numberOfObjects && this.source.getPosition() < firstObjectPosition; ++i) {
            long objectNumber = this.readObjectNumber();
            int offset = (int)this.readLong();
            objectOffsets.put(offset, objectNumber);
        }
        return objectOffsets;
    }

    public Map<Long, Integer> readObjectNumbers() throws IOException {
        Map<Long, Integer> objectNumbers = null;
        try {
            objectNumbers = this.privateReadObjectNumbers();
        }
        finally {
            this.source.close();
            this.document = null;
        }
        return objectNumbers;
    }
}

