/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdfparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.PDContentStream;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.Operator;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBoolean;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNull;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNumber;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfparser.BaseParser;

public class PDFStreamParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFStreamParser.class);
    private static final int MAX_BIN_CHAR_TEST_LENGTH = 10;
    private final byte[] binCharTestArr = new byte[10];
    private int inlineImageDepth = 0;
    private long inlineOffset = 0L;

    public PDFStreamParser(PDContentStream pdContentstream) throws IOException {
        super(pdContentstream.getContentsForStreamParsing());
    }

    public PDFStreamParser(byte[] bytes) {
        super(new RandomAccessReadBuffer(bytes));
    }

    public List<Object> parse() throws IOException {
        Object token;
        ArrayList<Object> streamObjects = new ArrayList<Object>(100);
        while ((token = this.parseNextToken()) != null) {
            streamObjects.add(token);
        }
        return streamObjects;
    }

    public Object parseNextToken() throws IOException {
        if (this.source.isClosed()) {
            return null;
        }
        this.skipSpaces();
        if (this.source.isEOF()) {
            this.close();
            return null;
        }
        char c = (char)this.source.peek();
        switch (c) {
            case '<': {
                this.source.read();
                c = (char)this.source.peek();
                this.source.rewind(1);
                if (c == '<') {
                    try {
                        return this.parseCOSDictionary(true);
                    }
                    catch (IOException exception) {
                        LOG.warn((Object)("Stop reading invalid dictionary from content stream at offset " + this.source.getPosition()));
                        this.close();
                        return null;
                    }
                }
                return this.parseCOSString();
            }
            case '[': {
                try {
                    return this.parseCOSArray();
                }
                catch (IOException exception) {
                    LOG.warn((Object)("Stop reading invalid array from content stream at offset " + this.source.getPosition()));
                    this.close();
                    return null;
                }
            }
            case '(': {
                return this.parseCOSString();
            }
            case '/': {
                return this.parseCOSName();
            }
            case 'n': {
                String nullString = this.readString();
                if (nullString.equals("null")) {
                    return COSNull.NULL;
                }
                return Operator.getOperator(nullString);
            }
            case 'f': 
            case 't': {
                String next = this.readString();
                if (next.equals("true")) {
                    return COSBoolean.TRUE;
                }
                if (next.equals("false")) {
                    return COSBoolean.FALSE;
                }
                return Operator.getOperator(next);
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean dotNotRead;
                StringBuilder buf = new StringBuilder();
                buf.append(c);
                this.source.read();
                if (c == '-' && this.source.peek() == c) {
                    this.source.read();
                }
                boolean bl = dotNotRead = c != '.';
                while (Character.isDigit(c = (char)this.source.peek()) || dotNotRead && c == '.' || c == '-') {
                    if (c != '-') {
                        buf.append(c);
                    }
                    this.source.read();
                    if (!dotNotRead || c != '.') continue;
                    dotNotRead = false;
                }
                String s = buf.toString();
                if ("+".equals(s)) {
                    LOG.warn((Object)"isolated '+' is ignored");
                    return COSNull.NULL;
                }
                return COSNumber.get(s);
            }
            case 'B': {
                String nextOperator = this.readString();
                Operator beginImageOP = Operator.getOperator(nextOperator);
                if (nextOperator.equals("BI")) {
                    ++this.inlineImageDepth;
                    if (this.inlineImageDepth > 1) {
                        throw new IOException("Nested 'BI' operator not allowed at offset " + this.source.getPosition() + ", first: " + this.inlineOffset);
                    }
                    this.inlineOffset = this.source.getPosition();
                    COSDictionary imageParams = new COSDictionary();
                    beginImageOP.setImageParameters(imageParams);
                    Object nextToken = null;
                    while ((nextToken = this.parseNextToken()) instanceof COSName) {
                        Object value = this.parseNextToken();
                        if (!(value instanceof COSBase)) {
                            LOG.warn((Object)("Unexpected token in inline image dictionary at offset " + (this.source.isClosed() ? "EOF" : Long.valueOf(this.source.getPosition()))));
                            break;
                        }
                        imageParams.setItem((COSName)nextToken, (COSBase)value);
                    }
                    if (nextToken instanceof Operator) {
                        Operator imageData = (Operator)nextToken;
                        if (imageData.getImageData() == null || imageData.getImageData().length == 0) {
                            LOG.warn((Object)("empty inline image at stream offset " + (this.source.isClosed() ? "EOF" : Long.valueOf(this.source.getPosition()))));
                        }
                        beginImageOP.setImageData(imageData.getImageData());
                        --this.inlineImageDepth;
                    } else {
                        LOG.warn((Object)("nextToken " + nextToken + " at position " + (this.source.isClosed() ? "EOF" : Long.valueOf(this.source.getPosition())) + ", expected " + "ID" + "?!"));
                    }
                }
                return beginImageOP;
            }
            case 'I': {
                String id = Character.toString((char)this.source.read()) + (char)this.source.read();
                if (!id.equals("ID")) {
                    long currentPosition = this.source.getPosition();
                    this.close();
                    throw new IOException("Error: Expected operator 'ID' actual='" + id + "' at stream offset " + currentPosition);
                }
                ByteArrayOutputStream imageData = new ByteArrayOutputStream();
                if (!this.skipLinebreak() && this.isWhitespace()) {
                    this.source.read();
                }
                int lastByte = this.source.read();
                int currentByte = this.source.read();
                while (!(lastByte == 69 && currentByte == 73 && this.hasNextSpaceOrReturn() && this.hasNoFollowingBinData() || this.isEOF())) {
                    imageData.write(lastByte);
                    lastByte = currentByte;
                    currentByte = this.source.read();
                }
                Operator beginImageDataOP = Operator.getOperator("ID");
                beginImageDataOP.setImageData(imageData.toByteArray());
                return beginImageDataOP;
            }
            case ']': {
                this.source.read();
                return COSNull.NULL;
            }
        }
        String operator = this.readOperator().trim();
        if (operator.length() > 0) {
            return Operator.getOperator(operator);
        }
        return null;
    }

    private boolean hasNoFollowingBinData() throws IOException {
        int readBytes = this.source.read(this.binCharTestArr, 0, 10);
        boolean noBinData = true;
        int startOpIdx = -1;
        int endOpIdx = -1;
        String s = "";
        if (readBytes > 0) {
            for (int bIdx = 0; bIdx < readBytes; ++bIdx) {
                byte b = this.binCharTestArr[bIdx];
                if (b != 0 && b < 9 || b > 10 && b < 32 && b != 13) {
                    noBinData = false;
                    break;
                }
                if (startOpIdx == -1 && b != 0 && b != 9 && b != 32 && b != 10 && b != 13) {
                    startOpIdx = bIdx;
                    continue;
                }
                if (startOpIdx == -1 || endOpIdx != -1 || b != 0 && b != 9 && b != 32 && b != 10 && b != 13) continue;
                endOpIdx = bIdx;
            }
            if (!(!noBinData || endOpIdx == -1 || startOpIdx == -1 || "Q".equals(s = new String(this.binCharTestArr, startOpIdx, endOpIdx - startOpIdx, StandardCharsets.US_ASCII)) || "EMC".equals(s) || "S".equals(s) || s.matches("^\\d*\\.?\\d*$"))) {
                noBinData = false;
            }
            if (noBinData && startOpIdx != -1 && readBytes == 10) {
                if (endOpIdx == -1) {
                    endOpIdx = 10;
                    s = new String(this.binCharTestArr, startOpIdx, endOpIdx - startOpIdx, StandardCharsets.US_ASCII);
                }
                if (endOpIdx - startOpIdx > 3 && !s.matches("^\\d*\\.?\\d*$")) {
                    noBinData = false;
                }
            }
            this.source.rewind(readBytes);
        }
        if (!noBinData) {
            LOG.warn((Object)("ignoring 'EI' assumed to be in the middle of inline image at stream offset " + this.source.getPosition() + ", s = '" + s + "'"));
        }
        return noBinData;
    }

    private String readOperator() throws IOException {
        this.skipSpaces();
        StringBuilder buffer = new StringBuilder(4);
        int nextChar = this.source.peek();
        while (!(nextChar == -1 || PDFStreamParser.isWhitespace(nextChar) || nextChar == 91 || nextChar == 60 || nextChar == 40 || nextChar == 47 || nextChar == 37 || nextChar >= 48 && nextChar <= 57)) {
            char currentChar = (char)this.source.read();
            nextChar = this.source.peek();
            buffer.append(currentChar);
            if (currentChar != 'd' || nextChar != 48 && nextChar != 49) continue;
            buffer.append((char)this.source.read());
            nextChar = this.source.peek();
        }
        return buffer.toString();
    }

    private boolean isSpaceOrReturn(int c) {
        return c == 10 || c == 13 || c == 32;
    }

    private boolean hasNextSpaceOrReturn() throws IOException {
        return this.isSpaceOrReturn(this.source.peek());
    }

    public void close() throws IOException {
        if (this.source != null && !this.source.isClosed()) {
            this.source.close();
        }
    }
}

