/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSInteger;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfparser.xref.FreeXReference;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfparser.xref.XReferenceEntry;

public class PDFXRefStream {
    private final List<XReferenceEntry> streamData = new ArrayList<XReferenceEntry>();
    private final Set<Long> objectNumbers = new TreeSet<Long>();
    private final COSStream stream;
    private long size = -1L;

    public PDFXRefStream(COSDocument cosDocument) {
        this.stream = cosDocument.createCOSStream();
    }

    public COSStream getStream() throws IOException {
        this.stream.setItem(COSName.TYPE, (COSBase)COSName.XREF);
        if (this.size == -1L) {
            throw new IllegalArgumentException("size is not set in xrefstream");
        }
        this.stream.setLong(COSName.SIZE, this.size);
        List<Long> indexEntry = this.getIndexEntry();
        COSArray indexAsArray = new COSArray();
        for (Long i : indexEntry) {
            indexAsArray.add(COSInteger.get(i));
        }
        this.stream.setItem(COSName.INDEX, (COSBase)indexAsArray);
        int[] wEntry = this.getWEntry();
        COSArray wAsArray = new COSArray();
        for (int j : wEntry) {
            wAsArray.add(COSInteger.get(j));
        }
        this.stream.setItem(COSName.W, (COSBase)wAsArray);
        OutputStream outputStream = this.stream.createOutputStream(COSName.FLATE_DECODE);
        Object object = null;
        try {
            this.writeStreamData(outputStream, wEntry);
            outputStream.flush();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (outputStream != null) {
                if (object != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    outputStream.close();
                }
            }
        }
        Set<COSName> keySet = this.stream.keySet();
        for (COSName cosName : keySet) {
            if (COSName.ROOT.equals(cosName) || COSName.INFO.equals(cosName) || COSName.PREV.equals(cosName) || COSName.ENCRYPT.equals(cosName)) continue;
            COSBase dictionaryObject = this.stream.getDictionaryObject(cosName);
            dictionaryObject.setDirect(true);
        }
        return this.stream;
    }

    public void addTrailerInfo(COSDictionary trailerDict) {
        trailerDict.forEach((key, value) -> {
            if (COSName.INFO.equals(key) || COSName.ROOT.equals(key) || COSName.ENCRYPT.equals(key) || COSName.ID.equals(key) || COSName.PREV.equals(key)) {
                this.stream.setItem((COSName)key, (COSBase)value);
            }
        });
    }

    public void addEntry(XReferenceEntry entry) {
        if (this.objectNumbers.contains(entry.getReferencedKey().getNumber())) {
            return;
        }
        this.objectNumbers.add(entry.getReferencedKey().getNumber());
        this.streamData.add(entry);
    }

    private int[] getWEntry() {
        long[] wMax = new long[3];
        for (XReferenceEntry entry : this.streamData) {
            wMax[0] = Math.max(wMax[0], entry.getFirstColumnValue());
            wMax[1] = Math.max(wMax[1], entry.getSecondColumnValue());
            wMax[2] = Math.max(wMax[2], entry.getThirdColumnValue());
        }
        int[] w = new int[3];
        for (int i = 0; i < w.length; ++i) {
            while (wMax[i] > 0L) {
                int n = i;
                w[n] = w[n] + 1;
                int n2 = i;
                wMax[n2] = wMax[n2] >> 8;
            }
        }
        return w;
    }

    public void setSize(long streamSize) {
        this.size = streamSize;
    }

    private List<Long> getIndexEntry() {
        LinkedList<Long> linkedList = new LinkedList<Long>();
        Long first = null;
        Long length = null;
        TreeSet<Long> objNumbers = new TreeSet<Long>();
        objNumbers.add(0L);
        objNumbers.addAll(this.objectNumbers);
        for (Long objNumber : objNumbers) {
            if (first == null) {
                first = objNumber;
                length = 1L;
            }
            if (first + length == objNumber) {
                length = length + 1L;
            }
            if (first + length >= objNumber) continue;
            linkedList.add(first);
            linkedList.add(length);
            first = objNumber;
            length = 1L;
        }
        linkedList.add(first);
        linkedList.add(length);
        return linkedList;
    }

    private void writeNumber(OutputStream os, long number, int bytes) throws IOException {
        int i;
        byte[] buffer = new byte[bytes];
        for (i = 0; i < bytes; ++i) {
            buffer[i] = (byte)(number & 0xFFL);
            number >>= 8;
        }
        for (i = 0; i < bytes; ++i) {
            os.write(buffer[bytes - i - 1]);
        }
    }

    private void writeStreamData(OutputStream os, int[] w) throws IOException {
        Collections.sort(this.streamData);
        FreeXReference nullEntry = FreeXReference.NULL_ENTRY;
        this.writeNumber(os, nullEntry.getFirstColumnValue(), w[0]);
        this.writeNumber(os, nullEntry.getSecondColumnValue(), w[1]);
        this.writeNumber(os, nullEntry.getThirdColumnValue(), w[2]);
        for (XReferenceEntry entry : this.streamData) {
            this.writeNumber(os, entry.getFirstColumnValue(), w[0]);
            this.writeNumber(os, entry.getSecondColumnValue(), w[1]);
            this.writeNumber(os, entry.getThirdColumnValue(), w[2]);
        }
    }
}

