/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.ResourceCache;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;

public class DefaultResourceCache
implements ResourceCache {
    private static final int maxRemovals = 3;
    private final boolean stableCacheEnabled;
    private final Map<COSObject, SoftReference<PDFont>> fonts = new HashMap<COSObject, SoftReference<PDFont>>();
    private final Map<Long, Integer> removedFonts = new HashMap<Long, Integer>();
    private final Set<Long> stableFonts = new HashSet<Long>();
    private final Map<COSObject, SoftReference<PDColorSpace>> colorSpaces = new HashMap<COSObject, SoftReference<PDColorSpace>>();
    private final Map<Long, Integer> removedColorSpaces = new HashMap<Long, Integer>();
    private final Set<Long> stableColorSpaces = new HashSet<Long>();
    private final Map<COSObject, SoftReference<PDXObject>> xobjects = new HashMap<COSObject, SoftReference<PDXObject>>();
    private final Map<Long, Integer> removedXObjects = new HashMap<Long, Integer>();
    private final Set<Long> stableXObject = new HashSet<Long>();
    private final Map<COSObject, SoftReference<PDExtendedGraphicsState>> extGStates = new HashMap<COSObject, SoftReference<PDExtendedGraphicsState>>();
    private final Map<Long, Integer> removedExtGStates = new HashMap<Long, Integer>();
    private final Set<Long> stableExtGStates = new HashSet<Long>();
    private final Map<COSObject, SoftReference<PDShading>> shadings = new HashMap<COSObject, SoftReference<PDShading>>();
    private final Map<Long, Integer> removedShadings = new HashMap<Long, Integer>();
    private final Set<Long> stableShadings = new HashSet<Long>();
    private final Map<COSObject, SoftReference<PDAbstractPattern>> patterns = new HashMap<COSObject, SoftReference<PDAbstractPattern>>();
    private final Map<Long, Integer> removedPatterns = new HashMap<Long, Integer>();
    private final Set<Long> stablePatterns = new HashSet<Long>();
    private final Map<COSObject, SoftReference<PDPropertyList>> properties = new HashMap<COSObject, SoftReference<PDPropertyList>>();
    private final Map<Long, Integer> removedProperties = new HashMap<Long, Integer>();
    private final Set<Long> stableProperties = new HashSet<Long>();

    public DefaultResourceCache() {
        this(true);
    }

    public DefaultResourceCache(boolean enableStableCache) {
        this.stableCacheEnabled = enableStableCache;
    }

    @Override
    public PDFont getFont(COSObject indirect) {
        SoftReference<PDFont> font = this.fonts.get(indirect);
        if (font != null) {
            return font.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDFont font) {
        this.fonts.put(indirect, new SoftReference<PDFont>(font));
    }

    @Override
    public PDFont removeFont(COSObject indirect) {
        SoftReference<PDFont> font;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stableFonts.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedFonts.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedFonts.put(objectKey, counter);
            } else {
                this.stableFonts.add(objectKey);
                this.removedFonts.remove(objectKey);
                return null;
            }
        }
        return (font = this.fonts.remove(indirect)) != null ? font.get() : null;
    }

    @Override
    public PDColorSpace getColorSpace(COSObject indirect) {
        SoftReference<PDColorSpace> colorSpace = this.colorSpaces.get(indirect);
        if (colorSpace != null) {
            return colorSpace.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDColorSpace colorSpace) {
        this.colorSpaces.put(indirect, new SoftReference<PDColorSpace>(colorSpace));
    }

    @Override
    public PDColorSpace removeColorSpace(COSObject indirect) {
        SoftReference<PDColorSpace> colorSpace;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stableColorSpaces.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedColorSpaces.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedColorSpaces.put(objectKey, counter);
            } else {
                this.stableColorSpaces.add(objectKey);
                this.removedColorSpaces.remove(objectKey);
                return null;
            }
        }
        return (colorSpace = this.colorSpaces.remove(indirect)) != null ? colorSpace.get() : null;
    }

    @Override
    public PDExtendedGraphicsState getExtGState(COSObject indirect) {
        SoftReference<PDExtendedGraphicsState> extGState = this.extGStates.get(indirect);
        if (extGState != null) {
            return extGState.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDExtendedGraphicsState extGState) {
        this.extGStates.put(indirect, new SoftReference<PDExtendedGraphicsState>(extGState));
    }

    @Override
    public PDExtendedGraphicsState removeExtState(COSObject indirect) {
        SoftReference<PDExtendedGraphicsState> extGState;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stableExtGStates.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedExtGStates.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedExtGStates.put(objectKey, counter);
            } else {
                this.stableExtGStates.add(objectKey);
                this.removedExtGStates.remove(objectKey);
                return null;
            }
        }
        return (extGState = this.extGStates.remove(indirect)) != null ? extGState.get() : null;
    }

    @Override
    public PDShading getShading(COSObject indirect) {
        SoftReference<PDShading> shading = this.shadings.get(indirect);
        if (shading != null) {
            return shading.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDShading shading) {
        this.shadings.put(indirect, new SoftReference<PDShading>(shading));
    }

    @Override
    public PDShading removeShading(COSObject indirect) {
        SoftReference<PDShading> shading;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stableShadings.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedShadings.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedShadings.put(objectKey, counter);
            } else {
                this.stableShadings.add(objectKey);
                this.removedShadings.remove(objectKey);
                return null;
            }
        }
        return (shading = this.shadings.remove(indirect)) != null ? shading.get() : null;
    }

    @Override
    public PDAbstractPattern getPattern(COSObject indirect) {
        SoftReference<PDAbstractPattern> pattern = this.patterns.get(indirect);
        if (pattern != null) {
            return pattern.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDAbstractPattern pattern) {
        this.patterns.put(indirect, new SoftReference<PDAbstractPattern>(pattern));
    }

    @Override
    public PDAbstractPattern removePattern(COSObject indirect) {
        SoftReference<PDAbstractPattern> pattern;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stablePatterns.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedPatterns.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedPatterns.put(objectKey, counter);
            } else {
                this.stablePatterns.add(objectKey);
                this.removedPatterns.remove(objectKey);
                return null;
            }
        }
        return (pattern = this.patterns.remove(indirect)) != null ? pattern.get() : null;
    }

    @Override
    public PDPropertyList getProperties(COSObject indirect) {
        SoftReference<PDPropertyList> propertyList = this.properties.get(indirect);
        if (propertyList != null) {
            return propertyList.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDPropertyList propertyList) {
        this.properties.put(indirect, new SoftReference<PDPropertyList>(propertyList));
    }

    @Override
    public PDPropertyList removeProperties(COSObject indirect) {
        SoftReference<PDPropertyList> propertyList;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stableProperties.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedProperties.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedProperties.put(objectKey, counter);
            } else {
                this.stableProperties.add(objectKey);
                this.removedProperties.remove(objectKey);
                return null;
            }
        }
        return (propertyList = this.properties.remove(indirect)) != null ? propertyList.get() : null;
    }

    @Override
    public PDXObject getXObject(COSObject indirect) {
        SoftReference<PDXObject> xobject = this.xobjects.get(indirect);
        if (xobject != null) {
            return xobject.get();
        }
        return null;
    }

    @Override
    public void put(COSObject indirect, PDXObject xobject) {
        this.xobjects.put(indirect, new SoftReference<PDXObject>(xobject));
    }

    @Override
    public PDXObject removeXObject(COSObject indirect) {
        SoftReference<PDXObject> xobject;
        Long objectKey;
        Long l = objectKey = this.stableCacheEnabled && indirect.getKey() != null ? Long.valueOf(indirect.getKey().getInternalHash()) : null;
        if (objectKey != null) {
            if (this.stableXObject.contains(objectKey)) {
                return null;
            }
            Integer counter = this.removedXObjects.computeIfAbsent(objectKey, v -> 1);
            if (counter < 3) {
                counter = counter + 1;
                this.removedXObjects.put(objectKey, counter);
            } else {
                this.stableXObject.add(objectKey);
                this.removedXObjects.remove(objectKey);
                return null;
            }
        }
        return (xobject = this.xobjects.remove(indirect)) != null ? xobject.get() : null;
    }
}

