/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.CmapLookup;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub.CompoundCharacterTokenizer;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub.GsubWorker;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.gsub.GsubWorkerFactory;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.model.GsubData;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.operator.OperatorName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNumber;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfwriter.COSWriter;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDResources;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.shade.org.apache.pdfbox.util.NumberFormatUtil;
import org.dromara.pdf.shade.org.apache.pdfbox.util.StringUtil;

public abstract class PDAbstractContentStream
implements Closeable {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected final PDDocument document;
    protected final OutputStream outputStream;
    protected PDResources resources;
    protected final Deque<PDFont> fontStack = new ArrayDeque<PDFont>();
    protected final Deque<PDColorSpace> nonStrokingColorSpaceStack = new ArrayDeque<PDColorSpace>();
    protected final Deque<PDColorSpace> strokingColorSpaceStack = new ArrayDeque<PDColorSpace>();
    protected final Map<PDType0Font, GsubWorker> gsubWorkers = new HashMap<PDType0Font, GsubWorker>();
    protected final NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private final byte[] formatBuffer = new byte[32];
    private final GsubWorkerFactory gsubWorkerFactory = new GsubWorkerFactory();
    protected boolean inTextMode = false;

    PDAbstractContentStream(PDDocument document, OutputStream outputStream) {
        this.document = document;
        this.outputStream = outputStream;
        this.formatDecimal.setMaximumFractionDigits(4);
        this.formatDecimal.setGroupingUsed(false);
    }

    PDAbstractContentStream(PDDocument document, OutputStream outputStream, PDResources resources) {
        this(document, outputStream);
        this.resources = resources;
    }

    protected void setMaximumFractionDigits(int fractionDigitsNumber) {
        this.formatDecimal.setMaximumFractionDigits(fractionDigitsNumber);
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: Nested beginText() calls are not allowed.");
        }
        this.writeOperator(OperatorName.BEGIN_TEXT_BYTES);
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Error: You must call beginText() before calling endText.");
        }
        this.writeOperator(OperatorName.END_TEXT_BYTES);
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        if (this.fontStack.isEmpty()) {
            this.fontStack.add(font);
        } else {
            this.fontStack.pop();
            this.fontStack.push(font);
        }
        if (font.willBeSubset()) {
            if (this.document != null) {
                this.document.getFontsToSubset().add(font);
            } else {
                this.LOG.warn((Object)("Using the subsetted font '" + font.getName() + "' without a PDDocument context; call subset() before saving"));
            }
        } else if (!font.isEmbedded() && !font.isStandard14() && this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("attempting to use font '" + font.getName() + "' that isn't embedded"));
        }
        if (font instanceof PDType0Font) {
            PDType0Font pdType0Font = (PDType0Font)font;
            GsubData gsubData = pdType0Font.getGsubData();
            if (gsubData != GsubData.NO_DATA_FOUND) {
                GsubWorker gsubWorker = this.gsubWorkerFactory.getGsubWorker(pdType0Font.getCmapLookup(), gsubData);
                this.gsubWorkers.put((PDType0Font)font, gsubWorker);
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("No GSUB data found in font" + font.getName()));
            }
        }
        this.writeOperand(this.resources.add(font));
        this.writeOperand(fontSize);
        this.writeOperator(OperatorName.SET_FONT_AND_SIZE_BYTES);
    }

    public void showTextWithPositioning(Object[] textWithPositioningArray) throws IOException {
        this.write("[");
        for (Object obj : textWithPositioningArray) {
            if (obj instanceof String) {
                this.showTextInternal((String)obj);
                continue;
            }
            if (obj instanceof Float) {
                this.writeOperand(((Float)obj).floatValue());
                continue;
            }
            throw new IllegalArgumentException("Argument must consist of array of Float and String types");
        }
        this.write("] ");
        this.writeOperator(OperatorName.SHOW_TEXT_ADJUSTED_BYTES);
    }

    public void showText(String text) throws IOException {
        this.showTextInternal(text);
        this.endTextInternal();
    }

    public void showCharacter(char character) throws IOException {
        this.showCharacterInternal(character);
        this.endTextInternal();
    }

    public void showCharacterInternal(char character) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Must call beginText() before showText()");
        }
        if (this.fontStack.isEmpty()) {
            throw new IllegalStateException("Must call setFont() before showText()");
        }
        PDFont font = this.fontStack.peek();
        if (font.willBeSubset()) {
            font.addToSubset(character);
        }
        COSWriter.writeString(font.encode(character), this.outputStream);
    }

    public void endTextInternal() throws IOException {
        this.outputStream.write(32);
        this.writeOperator(OperatorName.SHOW_TEXT_BYTES);
    }

    protected void showTextInternal(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Must call beginText() before showText()");
        }
        if (this.fontStack.isEmpty()) {
            throw new IllegalStateException("Must call setFont() before showText()");
        }
        PDFont font = this.fontStack.peek();
        byte[] encodedText = font.encode(text);
        if (font.willBeSubset()) {
            int codePoint;
            for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
        }
        COSWriter.writeString(encodedText, this.outputStream);
    }

    public void setLeading(float leading) throws IOException {
        this.writeOperand(leading);
        this.writeOperator(OperatorName.SET_TEXT_LEADING_BYTES);
    }

    public void newLine() throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Must call beginText() before newLine()");
        }
        this.writeOperator(OperatorName.NEXT_LINE_BYTES);
    }

    public void newLineAtOffset(float tx, float ty) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Error: must call beginText() before newLineAtOffset()");
        }
        this.writeOperand(tx);
        this.writeOperand(ty);
        this.writeOperator(OperatorName.MOVE_TEXT_BYTES);
    }

    public void setTextMatrix(Matrix matrix) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Error: must call beginText() before setTextMatrix");
        }
        this.writeAffineTransform(matrix.createAffineTransform());
        this.writeOperator(OperatorName.SET_MATRIX_BYTES);
    }

    public void drawImage(PDImageXObject image, float x, float y) throws IOException {
        this.drawImage(image, x, y, (float)image.getWidth(), (float)image.getHeight());
    }

    public void drawImage(PDImageXObject image, float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        AffineTransform transform = new AffineTransform(width, 0.0f, 0.0f, height, x, y);
        this.transform(new Matrix(transform));
        this.writeOperand(this.resources.add(image));
        this.writeOperator(OperatorName.DRAW_OBJECT_BYTES);
        this.restoreGraphicsState();
    }

    public void drawImage(PDImageXObject image, Matrix matrix) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        AffineTransform transform = matrix.createAffineTransform();
        this.transform(new Matrix(transform));
        this.writeOperand(this.resources.add(image));
        this.writeOperator(OperatorName.DRAW_OBJECT_BYTES);
        this.restoreGraphicsState();
    }

    public void drawImage(PDInlineImage inlineImage, float x, float y) throws IOException {
        this.drawImage(inlineImage, x, y, (float)inlineImage.getWidth(), (float)inlineImage.getHeight());
    }

    public void drawImage(PDInlineImage inlineImage, float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        this.transform(new Matrix(width, 0.0f, 0.0f, height, x, y));
        StringBuilder sb = new StringBuilder();
        sb.append("BI");
        sb.append("\n /W ");
        sb.append(inlineImage.getWidth());
        sb.append("\n /H ");
        sb.append(inlineImage.getHeight());
        sb.append("\n /CS ");
        sb.append('/');
        sb.append(inlineImage.getColorSpace().getName());
        COSArray decodeArray = inlineImage.getDecode();
        if (decodeArray != null && decodeArray.size() > 0) {
            sb.append("\n /D ");
            sb.append('[');
            for (COSBase base : decodeArray) {
                sb.append(((COSNumber)base).intValue());
                sb.append(' ');
            }
            sb.append(']');
        }
        if (inlineImage.isStencil()) {
            sb.append("\n /IM true");
        }
        sb.append("\n /BPC ");
        sb.append(inlineImage.getBitsPerComponent());
        this.write(sb.toString());
        this.writeLine();
        this.writeOperator(OperatorName.BEGIN_INLINE_IMAGE_DATA_BYTES);
        this.writeBytes(inlineImage.getData());
        this.writeLine();
        this.writeOperator(OperatorName.END_INLINE_IMAGE_BYTES);
        this.restoreGraphicsState();
    }

    public void drawForm(PDFormXObject form) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawForm is not allowed within a text block.");
        }
        this.writeOperand(this.resources.add(form));
        this.writeOperator(OperatorName.DRAW_OBJECT_BYTES);
    }

    public void transform(Matrix matrix) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: Modifying the current transformation matrix is not allowed within text objects.");
        }
        this.writeAffineTransform(matrix.createAffineTransform());
        this.writeOperator(OperatorName.CONCAT_BYTES);
    }

    public void saveGraphicsState() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: Saving the graphics state is not allowed within text objects.");
        }
        if (!this.fontStack.isEmpty()) {
            this.fontStack.push(this.fontStack.peek());
        }
        if (!this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.push(this.strokingColorSpaceStack.peek());
        }
        if (!this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.push(this.nonStrokingColorSpaceStack.peek());
        }
        this.writeOperator(OperatorName.SAVE_BYTES);
    }

    public void restoreGraphicsState() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: Restoring the graphics state is not allowed within text objects.");
        }
        if (!this.fontStack.isEmpty()) {
            this.fontStack.pop();
        }
        if (!this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.pop();
        }
        if (!this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.pop();
        }
        this.writeOperator(OperatorName.RESTORE_BYTES);
    }

    protected COSName getName(PDColorSpace colorSpace) {
        if (colorSpace instanceof PDDeviceGray || colorSpace instanceof PDDeviceRGB || colorSpace instanceof PDDeviceCMYK) {
            return COSName.getPDFName(colorSpace.getName());
        }
        return this.resources.add(colorSpace);
    }

    public void setStrokingColor(PDColor color) throws IOException {
        PDColorSpace colorSpace = color.getColorSpace();
        if (this.strokingColorSpaceStack.isEmpty() || this.strokingColorSpaceStack.peek() != colorSpace) {
            this.writeOperand(this.getName(colorSpace));
            this.writeOperator(OperatorName.STROKING_COLORSPACE_BYTES);
            this.setStrokingColorSpaceStack(colorSpace);
        }
        for (float value : color.getComponents()) {
            this.writeOperand(value);
        }
        if (colorSpace instanceof PDPattern) {
            this.writeOperand(color.getPatternName());
        }
        if (colorSpace instanceof PDPattern || colorSpace instanceof PDSeparation || colorSpace instanceof PDDeviceN || colorSpace instanceof PDICCBased) {
            this.writeOperator(OperatorName.STROKING_COLOR_N_BYTES);
        } else {
            this.writeOperator(OperatorName.STROKING_COLOR_BYTES);
        }
    }

    public void setStrokingColor(Color color) throws IOException {
        float[] components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        PDColor pdColor = new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE);
        this.setStrokingColor(pdColor);
    }

    public void setStrokingColor(float r, float g, float b) throws IOException {
        if (this.isOutsideOneInterval(r) || this.isOutsideOneInterval(g) || this.isOutsideOneInterval(b)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are " + String.format("(%.2f,%.2f,%.2f)", Float.valueOf(r), Float.valueOf(g), Float.valueOf(b)));
        }
        this.writeOperand(r);
        this.writeOperand(g);
        this.writeOperand(b);
        this.writeOperator(OperatorName.STROKING_COLOR_RGB_BYTES);
        this.setStrokingColorSpaceStack(PDDeviceRGB.INSTANCE);
    }

    public void setStrokingColor(float c, float m, float y, float k) throws IOException {
        if (this.isOutsideOneInterval(c) || this.isOutsideOneInterval(m) || this.isOutsideOneInterval(y) || this.isOutsideOneInterval(k)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are " + String.format("(%.2f,%.2f,%.2f,%.2f)", Float.valueOf(c), Float.valueOf(m), Float.valueOf(y), Float.valueOf(k)));
        }
        this.writeOperand(c);
        this.writeOperand(m);
        this.writeOperand(y);
        this.writeOperand(k);
        this.writeOperator(OperatorName.STROKING_COLOR_CMYK_BYTES);
        this.setStrokingColorSpaceStack(PDDeviceCMYK.INSTANCE);
    }

    public void setStrokingColor(float g) throws IOException {
        if (this.isOutsideOneInterval(g)) {
            throw new IllegalArgumentException("Parameter must be within 0..1, but is " + g);
        }
        this.writeOperand(g);
        this.writeOperator(OperatorName.STROKING_COLOR_GRAY_BYTES);
        this.setStrokingColorSpaceStack(PDDeviceGray.INSTANCE);
    }

    public void setNonStrokingColor(PDColor color) throws IOException {
        if (this.nonStrokingColorSpaceStack.isEmpty() || this.nonStrokingColorSpaceStack.peek() != color.getColorSpace()) {
            this.writeOperand(this.getName(color.getColorSpace()));
            this.writeOperator(OperatorName.NON_STROKING_COLORSPACE_BYTES);
            this.setNonStrokingColorSpaceStack(color.getColorSpace());
        }
        for (float value : color.getComponents()) {
            this.writeOperand(value);
        }
        if (color.getColorSpace() instanceof PDPattern) {
            this.writeOperand(color.getPatternName());
        }
        if (color.getColorSpace() instanceof PDPattern || color.getColorSpace() instanceof PDSeparation || color.getColorSpace() instanceof PDDeviceN || color.getColorSpace() instanceof PDICCBased) {
            this.writeOperator(OperatorName.NON_STROKING_COLOR_N_BYTES);
        } else {
            this.writeOperator(OperatorName.NON_STROKING_COLOR_BYTES);
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        float[] components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        PDColor pdColor = new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE);
        this.setNonStrokingColor(pdColor);
    }

    public void setNonStrokingColor(float r, float g, float b) throws IOException {
        if (this.isOutsideOneInterval(r) || this.isOutsideOneInterval(g) || this.isOutsideOneInterval(b)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are " + String.format("(%.2f,%.2f,%.2f)", Float.valueOf(r), Float.valueOf(g), Float.valueOf(b)));
        }
        this.writeOperand(r);
        this.writeOperand(g);
        this.writeOperand(b);
        this.writeOperator(OperatorName.NON_STROKING_RGB_BYTES);
        this.setNonStrokingColorSpaceStack(PDDeviceRGB.INSTANCE);
    }

    public void setNonStrokingColor(float c, float m, float y, float k) throws IOException {
        if (this.isOutsideOneInterval(c) || this.isOutsideOneInterval(m) || this.isOutsideOneInterval(y) || this.isOutsideOneInterval(k)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are " + String.format("(%.2f,%.2f,%.2f,%.2f)", Float.valueOf(c), Float.valueOf(m), Float.valueOf(y), Float.valueOf(k)));
        }
        this.writeOperand(c);
        this.writeOperand(m);
        this.writeOperand(y);
        this.writeOperand(k);
        this.writeOperator(OperatorName.NON_STROKING_CMYK_BYTES);
        this.setNonStrokingColorSpaceStack(PDDeviceCMYK.INSTANCE);
    }

    public void setNonStrokingColor(float g) throws IOException {
        if (this.isOutsideOneInterval(g)) {
            throw new IllegalArgumentException("Parameter must be within 0..1, but is " + g);
        }
        this.writeOperand(g);
        this.writeOperator(OperatorName.NON_STROKING_GRAY_BYTES);
        this.setNonStrokingColorSpaceStack(PDDeviceGray.INSTANCE);
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: addRect is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperand(width);
        this.writeOperand(height);
        this.writeOperator(OperatorName.APPEND_RECT_BYTES);
    }

    public void addRect(PDRectangle rectangle) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: addRect is not allowed within a text block.");
        }
        this.writeOperand(rectangle.getLowerLeftX());
        this.writeOperand(rectangle.getLowerLeftY());
        this.writeOperand(rectangle.getWidth());
        this.writeOperand(rectangle.getHeight());
        this.writeOperator(OperatorName.APPEND_RECT_BYTES);
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: curveTo is not allowed within a text block.");
        }
        this.writeOperand(x1);
        this.writeOperand(y1);
        this.writeOperand(x2);
        this.writeOperand(y2);
        this.writeOperand(x3);
        this.writeOperand(y3);
        this.writeOperator(OperatorName.CURVE_TO_BYTES);
    }

    public void curveTo2(float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: curveTo2 is not allowed within a text block.");
        }
        this.writeOperand(x2);
        this.writeOperand(y2);
        this.writeOperand(x3);
        this.writeOperand(y3);
        this.writeOperator(OperatorName.CURVE_TO_REPLICATE_INITIAL_POINT_BYTES);
    }

    public void curveTo1(float x1, float y1, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: curveTo1 is not allowed within a text block.");
        }
        this.writeOperand(x1);
        this.writeOperand(y1);
        this.writeOperand(x3);
        this.writeOperand(y3);
        this.writeOperator(OperatorName.CURVE_TO_REPLICATE_FINAL_POINT_BYTES);
    }

    public void moveTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: moveTo is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperator(OperatorName.MOVE_TO_BYTES);
    }

    public void lineTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: lineTo is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperator(OperatorName.LINE_TO_BYTES);
    }

    public void stroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: stroke is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.STROKE_PATH_BYTES);
    }

    public void closeAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closeAndStroke is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.CLOSE_AND_STROKE_BYTES);
    }

    public void fill() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fill is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.FILL_NON_ZERO_BYTES);
    }

    public void fillEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fillEvenOdd is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.FILL_EVEN_ODD_BYTES);
    }

    public void fillAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fillAndStroke is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.FILL_NON_ZERO_AND_STROKE_BYTES);
    }

    public void fillAndStrokeEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fillAndStrokeEvenOdd is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.FILL_EVEN_ODD_AND_STROKE_BYTES);
    }

    public void closeAndFillAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closeAndFillAndStroke is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.CLOSE_FILL_NON_ZERO_AND_STROKE_BYTES);
    }

    public void closeAndFillAndStrokeEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closeAndFillAndStrokeEvenOdd is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.CLOSE_FILL_EVEN_ODD_AND_STROKE_BYTES);
    }

    public void shadingFill(PDShading shading) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: shadingFill is not allowed within a text block.");
        }
        this.writeOperand(this.resources.add(shading));
        this.writeOperator(OperatorName.SHADING_FILL_BYTES);
    }

    public void closePath() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closePath is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.CLOSE_PATH_BYTES);
    }

    public void clip() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: clip is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.CLIP_NON_ZERO_BYTES);
        this.writeOperator(OperatorName.ENDPATH_BYTES);
    }

    public void clipEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: clipEvenOdd is not allowed within a text block.");
        }
        this.writeOperator(OperatorName.CLIP_EVEN_ODD_BYTES);
        this.writeOperator(OperatorName.ENDPATH_BYTES);
    }

    public void setLineWidth(float lineWidth) throws IOException {
        this.writeOperand(lineWidth);
        this.writeOperator(OperatorName.SET_LINE_WIDTH_BYTES);
    }

    public void setLineJoinStyle(int lineJoinStyle) throws IOException {
        if (lineJoinStyle < 0 || lineJoinStyle > 2) {
            throw new IllegalArgumentException("Error: unknown value for line join style");
        }
        this.writeOperand(lineJoinStyle);
        this.writeOperator(OperatorName.SET_LINE_JOINSTYLE_BYTES);
    }

    public void setLineCapStyle(int lineCapStyle) throws IOException {
        if (lineCapStyle < 0 || lineCapStyle > 2) {
            throw new IllegalArgumentException("Error: unknown value for line cap style");
        }
        this.writeOperand(lineCapStyle);
        this.writeOperator(OperatorName.SET_LINE_CAPSTYLE_BYTES);
    }

    public void setLineDashPattern(float[] pattern, float phase) throws IOException {
        this.write("[");
        for (float value : pattern) {
            this.writeOperand(value);
        }
        this.write("] ");
        this.writeOperand(phase);
        this.writeOperator(OperatorName.SET_LINE_DASHPATTERN_BYTES);
    }

    public void setMiterLimit(float miterLimit) throws IOException {
        if ((double)miterLimit <= 0.0) {
            throw new IllegalArgumentException("A miter limit <= 0 is invalid and will not render in Acrobat Reader");
        }
        this.writeOperand(miterLimit);
        this.writeOperator(OperatorName.SET_LINE_MITERLIMIT_BYTES);
    }

    public void beginMarkedContent(COSName tag) throws IOException {
        this.writeOperand(tag);
        this.writeOperator(OperatorName.BEGIN_MARKED_CONTENT_BYTES);
    }

    public void beginMarkedContent(COSName tag, int mcid) throws IOException {
        if (mcid < 0) {
            throw new IllegalArgumentException("mcid should not be negative");
        }
        this.writeOperand(tag);
        this.write("<</MCID " + mcid + ">> ");
        this.writeOperator(OperatorName.BEGIN_MARKED_CONTENT_SEQ_BYTES);
    }

    public void beginMarkedContent(COSName tag, PDPropertyList propertyList) throws IOException {
        this.writeOperand(tag);
        COSDictionary dict = propertyList.getCOSObject();
        if (dict.getInt(COSName.MCID) > -1 && dict.size() == 1) {
            this.write("<</MCID " + dict.getInt(COSName.MCID) + ">> ");
        } else {
            this.writeOperand(this.resources.add(propertyList));
        }
        this.writeOperator(OperatorName.BEGIN_MARKED_CONTENT_SEQ_BYTES);
    }

    public void endMarkedContent() throws IOException {
        this.writeOperator(OperatorName.END_MARKED_CONTENT_BYTES);
    }

    public void setMarkedContentPoint(COSName tag) throws IOException {
        this.writeOperand(tag);
        this.writeOperator(OperatorName.MARKED_CONTENT_POINT_BYTES);
    }

    public void setMarkedContentPointWithProperties(COSName tag, PDPropertyList propertyList) throws IOException {
        this.writeOperand(tag);
        this.writeOperand(this.resources.add(propertyList));
        this.writeOperator(OperatorName.MARKED_CONTENT_POINT_WITH_PROPS_BYTES);
    }

    public void setGraphicsStateParameters(PDExtendedGraphicsState state) throws IOException {
        this.writeOperand(this.resources.add(state));
        this.writeOperator(OperatorName.SET_GRAPHICS_STATE_PARAMS_BYTES);
    }

    public void addComment(String comment) throws IOException {
        if (comment.indexOf(10) >= 0 || comment.indexOf(13) >= 0) {
            throw new IllegalArgumentException("comment should not include a newline");
        }
        this.outputStream.write(37);
        this.outputStream.write(comment.getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(10);
    }

    protected void writeOperand(float real) throws IOException {
        if (!Float.isFinite(real)) {
            throw new IllegalArgumentException(real + " is not a finite number");
        }
        int byteCount = NumberFormatUtil.formatFloatFast(real, this.formatDecimal.getMaximumFractionDigits(), this.formatBuffer);
        if (byteCount == -1) {
            this.write(this.formatDecimal.format(real));
        } else {
            this.outputStream.write(this.formatBuffer, 0, byteCount);
        }
        this.outputStream.write(32);
    }

    protected void writeOperand(int integer) throws IOException {
        this.write(this.formatDecimal.format(integer));
        this.outputStream.write(32);
    }

    protected void writeOperand(COSName name) throws IOException {
        name.writePDF(this.outputStream);
        this.outputStream.write(32);
    }

    protected void writeOperand(String text) throws IOException {
        this.write(text);
        this.outputStream.write(32);
    }

    protected void writeOperand(byte[] data) throws IOException {
        this.writeBytes(data);
        this.outputStream.write(32);
    }

    public void writeOperator(String text) throws IOException {
        this.write(text);
        this.writeLine();
    }

    public void writeOperator(byte[] data) throws IOException {
        this.writeBytes(data);
        this.writeLine();
    }

    protected void write(String text) throws IOException {
        this.writeBytes(text.getBytes(StandardCharsets.US_ASCII));
    }

    protected void writeLine() throws IOException {
        this.outputStream.write(10);
    }

    protected void writeBytes(byte[] data) throws IOException {
        this.outputStream.write(data);
    }

    private void writeAffineTransform(AffineTransform transform) throws IOException {
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            this.writeOperand((float)v);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inTextMode) {
            this.LOG.warn((Object)"You did not call endText(), some viewers won't display your text");
        }
        this.outputStream.close();
    }

    protected boolean isOutside255Interval(int val) {
        return val < 0 || val > 255;
    }

    private boolean isOutsideOneInterval(double val) {
        return val < 0.0 || val > 1.0;
    }

    protected void setStrokingColorSpaceStack(PDColorSpace colorSpace) {
        if (this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.add(colorSpace);
        } else {
            this.strokingColorSpaceStack.pop();
            this.strokingColorSpaceStack.push(colorSpace);
        }
    }

    protected void setNonStrokingColorSpaceStack(PDColorSpace colorSpace) {
        if (this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.add(colorSpace);
        } else {
            this.nonStrokingColorSpaceStack.pop();
            this.nonStrokingColorSpaceStack.push(colorSpace);
        }
    }

    public void setCharacterSpacing(float spacing) throws IOException {
        this.writeOperand(spacing);
        this.writeOperator(OperatorName.SET_CHAR_SPACING_BYTES);
    }

    public void setWordSpacing(float spacing) throws IOException {
        this.writeOperand(spacing);
        this.writeOperator(OperatorName.SET_WORD_SPACING_BYTES);
    }

    public void setHorizontalScaling(float scale) throws IOException {
        this.writeOperand(scale);
        this.writeOperator(OperatorName.SET_TEXT_HORIZONTAL_SCALING_BYTES);
    }

    public void setRenderingMode(RenderingMode rm) throws IOException {
        this.writeOperand(rm.intValue());
        this.writeOperand(OperatorName.SET_TEXT_RENDERINGMODE_BYTES);
    }

    public void setTextRise(float rise) throws IOException {
        this.writeOperand(rise);
        this.writeOperator(OperatorName.SET_TEXT_RISE_BYTES);
    }

    protected byte[] encodeForGsub(GsubWorker gsubWorker, Set<Integer> glyphIds, PDType0Font font, String text) throws IOException {
        List<String> words = new CompoundCharacterTokenizer(StringUtil.PATTERN_SPACE).tokenize(text);
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        for (String word : words) {
            if (StringUtil.PATTERN_SPACE.matcher(word).matches()) {
                out.write(font.encode(word));
                continue;
            }
            glyphIds.addAll(this.applyGSUBRules(gsubWorker, out, font, word));
        }
        return out.toByteArray();
    }

    protected List<Integer> applyGSUBRules(GsubWorker gsubWorker, ByteArrayOutputStream out, PDType0Font font, String word) throws IOException {
        char[] charArray = word.toCharArray();
        ArrayList<Integer> originalGlyphIds = new ArrayList<Integer>(charArray.length);
        CmapLookup cmapLookup = font.getCmapLookup();
        for (char unicodeChar : charArray) {
            int glyphId = cmapLookup.getGlyphId(unicodeChar);
            if (glyphId <= 0) {
                throw new IllegalStateException("could not find the glyphId for the character: " + unicodeChar);
            }
            originalGlyphIds.add(glyphId);
        }
        List<Integer> glyphIdsAfterGsub = gsubWorker.applyTransforms(originalGlyphIds);
        for (Integer glyphId : glyphIdsAfterGsub) {
            out.write(font.encodeGlyphId(glyphId));
        }
        return glyphIdsAfterGsub;
    }

    protected byte[] encodeForGsub(GsubWorker gsubWorker, Set<Integer> glyphIds, PDType0Font font, Character character) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        if (character.charValue() == ' ') {
            glyphIds.addAll(this.applyGSUBRules(gsubWorker, out, font, character));
        } else {
            out.write(font.encode(character.charValue()));
        }
        return out.toByteArray();
    }

    protected List<Integer> applyGSUBRules(GsubWorker gsubWorker, ByteArrayOutputStream out, PDType0Font font, Character unicodeChar) throws IOException {
        ArrayList<Integer> originalGlyphIds = new ArrayList<Integer>(1);
        CmapLookup cmapLookup = font.getCmapLookup();
        int glyphId = cmapLookup.getGlyphId(unicodeChar.charValue());
        if (glyphId <= 0) {
            throw new IllegalStateException("could not find the glyphId for the character: " + unicodeChar);
        }
        originalGlyphIds.add(glyphId);
        List<Integer> glyphIdsAfterGsub = gsubWorker.applyTransforms(originalGlyphIds);
        for (Integer id : glyphIdsAfterGsub) {
            out.write(font.encodeGlyphId(id));
        }
        return glyphIdsAfterGsub;
    }
}

