/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import java.util.StringJoiner;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDDictionaryWrapper;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDDefaultAttributeObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDUserAttributeObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDExportFormatAttributeObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDLayoutAttributeObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDListAttributeObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDPrintFieldAttributeObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDTableAttributeObject;

public abstract class PDAttributeObject
extends PDDictionaryWrapper {
    private PDStructureElement structureElement;

    public PDAttributeObject() {
    }

    public PDAttributeObject(COSDictionary dictionary) {
        super(dictionary);
    }

    public static PDAttributeObject create(COSDictionary dictionary) {
        String owner = dictionary.getNameAsString(COSName.O);
        if (owner != null) {
            switch (owner) {
                case "UserProperties": {
                    return new PDUserAttributeObject(dictionary);
                }
                case "List": {
                    return new PDListAttributeObject(dictionary);
                }
                case "PrintField": {
                    return new PDPrintFieldAttributeObject(dictionary);
                }
                case "Table": {
                    return new PDTableAttributeObject(dictionary);
                }
                case "Layout": {
                    return new PDLayoutAttributeObject(dictionary);
                }
                case "XML-1.00": 
                case "HTML-3.2": 
                case "HTML-4.01": 
                case "OEB-1.00": 
                case "RTF-1.05": 
                case "CSS-1.00": 
                case "CSS-2.00": {
                    return new PDExportFormatAttributeObject(dictionary);
                }
            }
        }
        return new PDDefaultAttributeObject(dictionary);
    }

    private PDStructureElement getStructureElement() {
        return this.structureElement;
    }

    protected void setStructureElement(PDStructureElement structureElement) {
        this.structureElement = structureElement;
    }

    public String getOwner() {
        return this.getCOSObject().getNameAsString(COSName.O);
    }

    protected void setOwner(String owner) {
        this.getCOSObject().setName(COSName.O, owner);
    }

    public boolean isEmpty() {
        return this.getCOSObject().size() == 1 && this.getOwner() != null;
    }

    protected void potentiallyNotifyChanged(COSBase oldBase, COSBase newBase) {
        if (this.isValueChanged(oldBase, newBase)) {
            this.notifyChanged();
        }
    }

    private boolean isValueChanged(COSBase oldValue, COSBase newValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    protected void notifyChanged() {
        if (this.getStructureElement() != null) {
            this.getStructureElement().attributeChanged(this);
        }
    }

    public String toString() {
        return "O=" + this.getOwner();
    }

    protected static String arrayToString(Object[] array) {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Object o : array) {
            sj.add(o.toString());
        }
        return sj.toString();
    }

    protected static String arrayToString(float[] array) {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (float f : array) {
            sj.add(Float.toString(f));
        }
        return sj.toString();
    }
}

