/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessRead;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfwriter.COSWriter;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf.FDFCatalog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FDFDocument
implements Closeable {
    private static final Log LOG = LogFactory.getLog(FDFDocument.class);
    private final COSDocument document;
    private final RandomAccessRead fdfSource;

    public FDFDocument() {
        this.fdfSource = null;
        this.document = new COSDocument();
        this.document.getDocumentState().setParsing(false);
        this.document.setVersion(1.2f);
        this.document.setTrailer(new COSDictionary());
        FDFCatalog catalog = new FDFCatalog();
        this.setCatalog(catalog);
    }

    @Deprecated
    public FDFDocument(COSDocument doc) {
        this(doc, null);
    }

    public FDFDocument(COSDocument doc, RandomAccessRead source) {
        this.document = doc;
        this.document.getDocumentState().setParsing(false);
        this.fdfSource = source;
    }

    public FDFDocument(Document doc) throws IOException {
        this();
        Element xfdf = doc.getDocumentElement();
        if (!xfdf.getNodeName().equals("xfdf")) {
            throw new IOException("Error while importing xfdf document, root should be 'xfdf' and not '" + xfdf.getNodeName() + "'");
        }
        FDFCatalog cat = new FDFCatalog(xfdf);
        this.setCatalog(cat);
    }

    public void writeXML(Writer output) throws IOException {
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("<xfdf xmlns=\"http://ns.adobe.com/xfdf/\" xml:space=\"preserve\">\n");
        this.getCatalog().writeXML(output);
        output.write("</xfdf>\n");
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public FDFCatalog getCatalog() {
        FDFCatalog retval = null;
        COSDictionary trailer = this.document.getTrailer();
        COSDictionary root = trailer.getCOSDictionary(COSName.ROOT);
        if (root == null) {
            retval = new FDFCatalog();
            this.setCatalog(retval);
        } else {
            retval = new FDFCatalog(root);
        }
        return retval;
    }

    public final void setCatalog(FDFCatalog cat) {
        COSDictionary trailer = this.document.getTrailer();
        trailer.setItem(COSName.ROOT, (COSObjectable)cat);
    }

    public void save(File fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            this.save(fos);
        }
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    public void save(OutputStream output) throws IOException {
        COSWriter writer = new COSWriter(output);
        writer.write(this);
    }

    public void saveXFDF(File fileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));){
            this.saveXFDF(writer);
        }
    }

    public void saveXFDF(String fileName) throws IOException {
        this.saveXFDF(new File(fileName));
    }

    public void saveXFDF(Writer output) throws IOException {
        try {
            this.writeXML(output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.document.isClosed()) {
            IOException firstException = null;
            firstException = IOUtils.closeAndLogException(this.document, LOG, "COSDocument", firstException);
            if (this.fdfSource != null) {
                firstException = IOUtils.closeAndLogException(this.fdfSource, LOG, "RandomAccessRead pdfSource", firstException);
            }
            if (firstException != null) {
                throw firstException;
            }
        }
    }
}

