/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSInteger;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNumber;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSString;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf.FDFIconFit;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf.FDFNamedPageReference;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf.FDFOptionElement;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.action.PDAdditionalActions;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFField
implements COSObjectable {
    private final COSDictionary field;

    public FDFField() {
        this.field = new COSDictionary();
    }

    public FDFField(COSDictionary f) {
        this.field = f;
    }

    public FDFField(Element fieldXML) throws IOException {
        this();
        this.setPartialFieldName(fieldXML.getAttribute("name"));
        NodeList nodeList = fieldXML.getChildNodes();
        ArrayList<FDFField> kids = new ArrayList<FDFField>();
        block10: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            switch (child.getTagName()) {
                case "value": {
                    this.setValue(XMLUtil.getNodeValue(child));
                    continue block10;
                }
                case "value-richtext": {
                    this.setRichText(new COSString(XMLUtil.getNodeValue(child)));
                    continue block10;
                }
                case "field": {
                    kids.add(new FDFField(child));
                    continue block10;
                }
            }
        }
        if (kids.size() > 0) {
            this.setKids(kids);
        }
    }

    public void writeXML(Writer output) throws IOException {
        List<FDFField> kids;
        output.write("<field name=\"");
        output.write(this.getPartialFieldName());
        output.write("\">\n");
        Object value = this.getValue();
        if (value instanceof String) {
            output.write("<value>");
            output.write(this.escapeXML((String)value));
            output.write("</value>\n");
        } else if (value instanceof List) {
            List items = (List)value;
            for (String item : items) {
                output.write("<value>");
                output.write(this.escapeXML(item));
                output.write("</value>\n");
            }
        }
        String rt = this.getRichText();
        if (rt != null) {
            output.write("<value-richtext>");
            output.write(this.escapeXML(rt));
            output.write("</value-richtext>\n");
        }
        if ((kids = this.getKids()) != null) {
            for (FDFField kid : kids) {
                kid.writeXML(output);
            }
        }
        output.write("</field>\n");
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.field;
    }

    public List<FDFField> getKids() {
        COSArray kids = this.field.getCOSArray(COSName.KIDS);
        if (kids != null) {
            ArrayList<FDFField> actuals = new ArrayList<FDFField>(kids.size());
            for (int i = 0; i < kids.size(); ++i) {
                actuals.add(new FDFField((COSDictionary)kids.getObject(i)));
            }
            return new COSArrayList<FDFField>(actuals, kids);
        }
        return null;
    }

    public final void setKids(List<FDFField> kids) {
        this.field.setItem(COSName.KIDS, (COSBase)new COSArray(kids));
    }

    public String getPartialFieldName() {
        return this.field.getString(COSName.T);
    }

    public void setPartialFieldName(String partial) {
        this.field.setString(COSName.T, partial);
    }

    public Object getValue() throws IOException {
        COSBase value = this.field.getDictionaryObject(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        if (value instanceof COSArray) {
            return ((COSArray)value).toCOSStringStringList();
        }
        if (value instanceof COSString) {
            return ((COSString)value).getString();
        }
        if (value instanceof COSStream) {
            return ((COSStream)value).toTextString();
        }
        if (value != null) {
            throw new IOException("Error: Unknown type for field import: " + value);
        }
        return null;
    }

    public COSBase getCOSValue() throws IOException {
        COSBase value = this.field.getDictionaryObject(COSName.V);
        if (value instanceof COSName || value instanceof COSArray || value instanceof COSString || value instanceof COSStream) {
            return value;
        }
        if (value != null) {
            throw new IOException("Error: Unknown type for field import: " + value);
        }
        return null;
    }

    public void setValue(Object value) throws IOException {
        COSBase cos = null;
        if (value instanceof List) {
            cos = COSArray.ofCOSStrings((List)value);
        } else if (value instanceof String) {
            cos = new COSString((String)value);
        } else if (value instanceof COSObjectable) {
            cos = ((COSObjectable)value).getCOSObject();
        } else if (value != null) {
            throw new IOException("Error: Unknown type for field import: " + value);
        }
        this.field.setItem(COSName.V, cos);
    }

    public void setValue(COSBase value) {
        this.field.setItem(COSName.V, value);
    }

    public Integer getFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.FF, (COSBase)value);
    }

    public void setFieldFlags(int ff) {
        this.field.setInt(COSName.FF, ff);
    }

    public Integer getSetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.SET_FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setSetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.SET_FF, (COSBase)value);
    }

    public void setSetFieldFlags(int ff) {
        this.field.setInt(COSName.SET_FF, ff);
    }

    public Integer getClearFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.CLR_FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setClearFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.CLR_FF, (COSBase)value);
    }

    public void setClearFieldFlags(int ff) {
        this.field.setInt(COSName.CLR_FF, ff);
    }

    public Integer getWidgetFieldFlags() {
        Integer retval = null;
        COSNumber f = (COSNumber)this.field.getDictionaryObject(COSName.F);
        if (f != null) {
            retval = f.intValue();
        }
        return retval;
    }

    public void setWidgetFieldFlags(Integer f) {
        COSInteger value = null;
        if (f != null) {
            value = COSInteger.get(f.intValue());
        }
        this.field.setItem(COSName.F, (COSBase)value);
    }

    public void setWidgetFieldFlags(int f) {
        this.field.setInt(COSName.F, f);
    }

    public Integer getSetWidgetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.SET_F);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setSetWidgetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.SET_F, (COSBase)value);
    }

    public void setSetWidgetFieldFlags(int ff) {
        this.field.setInt(COSName.SET_F, ff);
    }

    public Integer getClearWidgetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.CLR_F);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setClearWidgetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.CLR_F, (COSBase)value);
    }

    public void setClearWidgetFieldFlags(int ff) {
        this.field.setInt(COSName.CLR_F, ff);
    }

    public PDAppearanceDictionary getAppearanceDictionary() {
        COSDictionary dict = this.field.getCOSDictionary(COSName.AP);
        return dict != null ? new PDAppearanceDictionary(dict) : null;
    }

    public void setAppearanceDictionary(PDAppearanceDictionary ap) {
        this.field.setItem(COSName.AP, (COSObjectable)ap);
    }

    public FDFNamedPageReference getAppearanceStreamReference() {
        COSDictionary ref = this.field.getCOSDictionary(COSName.AP_REF);
        return ref != null ? new FDFNamedPageReference(ref) : null;
    }

    public void setAppearanceStreamReference(FDFNamedPageReference ref) {
        this.field.setItem(COSName.AP_REF, (COSObjectable)ref);
    }

    public FDFIconFit getIconFit() {
        COSDictionary dic = this.field.getCOSDictionary(COSName.IF);
        return dic != null ? new FDFIconFit(dic) : null;
    }

    public void setIconFit(FDFIconFit fit) {
        this.field.setItem(COSName.IF, (COSObjectable)fit);
    }

    public List<Object> getOptions() {
        COSArray array = this.field.getCOSArray(COSName.OPT);
        if (array != null) {
            ArrayList<Object> objects = new ArrayList<Object>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                COSBase next = array.getObject(i);
                if (next instanceof COSString) {
                    objects.add(((COSString)next).getString());
                    continue;
                }
                COSArray value = (COSArray)next;
                objects.add(new FDFOptionElement(value));
            }
            return new COSArrayList<Object>(objects, array);
        }
        return null;
    }

    public void setOptions(List<Object> options) {
        COSArray value = COSArrayList.converterToCOSArray(options);
        this.field.setItem(COSName.OPT, (COSBase)value);
    }

    public PDAction getAction() {
        return PDActionFactory.createAction(this.field.getCOSDictionary(COSName.A));
    }

    public void setAction(PDAction a) {
        this.field.setItem(COSName.A, (COSObjectable)a);
    }

    public PDAdditionalActions getAdditionalActions() {
        COSDictionary dict = this.field.getCOSDictionary(COSName.AA);
        return dict != null ? new PDAdditionalActions(dict) : null;
    }

    public void setAdditionalActions(PDAdditionalActions aa) {
        this.field.setItem(COSName.AA, (COSObjectable)aa);
    }

    public String getRichText() {
        COSBase rv = this.field.getDictionaryObject(COSName.RV);
        if (rv == null) {
            return null;
        }
        if (rv instanceof COSString) {
            return ((COSString)rv).getString();
        }
        return ((COSStream)rv).toTextString();
    }

    public void setRichText(COSString rv) {
        this.field.setItem(COSName.RV, (COSBase)rv);
    }

    public void setRichText(COSStream rv) {
        this.field.setItem(COSName.RV, (COSBase)rv);
    }

    private String escapeXML(String input) {
        StringBuilder escapedXML = new StringBuilder();
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    escapedXML.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedXML.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escapedXML.append("&quot;");
                    continue block7;
                }
                case '&': {
                    escapedXML.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    escapedXML.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        escapedXML.append("&#").append((int)c).append(';');
                        continue block7;
                    }
                    escapedXML.append(c);
                }
            }
        }
        return escapedXML.toString();
    }
}

